/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.check;

import io.gatling.commons.util.Equality;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.Validator;
import io.gatling.core.check.Validator$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg!B\u0015+\u0003\u0003\u0019\u0004\"\u0002&\u0001\t\u0003Y\u0005\"B'\u0001\r#q\u0005\"\u0002/\u0001\t\u0003iv!\u00023+\u0011\u0003)g!B\u0015+\u0011\u00031\u0007\"\u0002&\u0006\t\u00039g\u0001\u00025\u0006\u0005%D\u0001B\\\u0004\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\t_\u001e\u0011\t\u0011)A\u0005a\")!j\u0002C\u0001m\")1p\u0002C\u0001y\"1Qj\u0002C\t\u0003\u00171a!a\u0005\u0006\u0005\u0005U\u0001B\u0002&\u000e\t\u0003\ty\u0002C\u0003|\u001b\u0011\u0005A\u0010\u0003\u0004N\u001b\u0011E\u00111\u0005\u0004\u0007\u0003W)!!!\f\t\u00139\f\"\u0011!Q\u0001\n\u0005M\u0002\"C8\u0012\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011\u0019Q\u0015\u0003\"\u0001\u0002:!)10\u0005C\u0001y\"1Q*\u0005C\t\u0003\u00032a!!\u0013\u0006\u0005\u0005-\u0003B\u0002&\u0018\t\u0003\t)\u0006C\u0003|/\u0011\u0005A\u0010\u0003\u0004N/\u0011E\u0011\u0011\f\u0004\u0007\u0003C*!!a\u0019\t\u00139\\\"\u0011!Q\u0001\n\u00055\u0004B\u0002&\u001c\t\u0003\t)\t\u0003\u0004|7\u0011\u0005\u00111\u0012\u0005\u0007\u001bn!\t\"a'\u0007\r\u0005\rVAAAS\u0011)\ty\u000b\tBC\u0002\u0013\u0005\u00111\u0012\u0005\u000b\u0003c\u0003#\u0011!Q\u0001\n\u00055\u0005BCAZA\t\u0005\t\u0015!\u0003\u0002\u000e\"Q\u0011Q\u0017\u0011\u0003\u0002\u0003\u0006I!a.\t\u00139\u0004#\u0011!Q\u0001\n\u0005-\u0006B\u0002&!\t\u0003\ti\fC\u0003|A\u0011\u0005A\u0010\u0003\u0004NA\u0011E\u0011\u0011\u001a\u0002\b\u001b\u0006$8\r[3s\u0015\tYC&A\u0003dQ\u0016\u001c7N\u0003\u0002.]\u0005!1m\u001c:f\u0015\ty\u0003'A\u0004hCRd\u0017N\\4\u000b\u0003E\n!![8\u0004\u0001U\u0011A'Q\n\u0004\u0001UZ\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g\rE\u0002={}j\u0011AK\u0005\u0003})\u0012\u0011BV1mS\u0012\fGo\u001c:\u0011\u0005\u0001\u000bE\u0002\u0001\u0003\u0006\u0005\u0002\u0011\ra\u0011\u0002\u0002\u0003F\u0011Ai\u0012\t\u0003m\u0015K!AR\u001c\u0003\u000f9{G\u000f[5oOB\u0011a\u0007S\u0005\u0003\u0013^\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\tA\nE\u0002=\u0001}\nq\u0001Z8NCR\u001c\u0007\u000e\u0006\u0002P5B\u0019\u0001+V,\u000e\u0003ES!AU*\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002U]\u000591m\\7n_:\u001c\u0018B\u0001,R\u0005)1\u0016\r\\5eCRLwN\u001c\t\u0004ma{\u0014BA-8\u0005\u0019y\u0005\u000f^5p]\")1L\u0001a\u0001/\u00061\u0011m\u0019;vC2\fQ!\u00199qYf$2a\u00140`\u0011\u0015Y6\u00011\u0001X\u0011\u0015\u00017\u00011\u0001b\u0003I!\u0017n\u001d9mCf\f5\r^;bYZ\u000bG.^3\u0011\u0005Y\u0012\u0017BA28\u0005\u001d\u0011un\u001c7fC:\fq!T1uG\",'\u000f\u0005\u0002=\u000bM\u0011Q!\u000e\u000b\u0002K\n\u0011\u0011j]\u000b\u0003U6\u001c\"aB6\u0011\u0007q\u0002A\u000e\u0005\u0002A[\u0012)!i\u0002b\u0001\u0007\u0006AQ\r\u001f9fGR,G-\u0001\u0005fcV\fG.\u001b;z!\r\tH\u000f\\\u0007\u0002e*\u00111oU\u0001\u0005kRLG.\u0003\u0002ve\nAQ)];bY&$\u0018\u0010F\u0002xsj\u00042\u0001_\u0004m\u001b\u0005)\u0001\"\u00028\u000b\u0001\u0004a\u0007\"B8\u000b\u0001\u0004\u0001\u0018\u0001\u00028b[\u0016,\u0012! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0007'R\u0014\u0018N\\4\u0015\t\u00055\u0011\u0011\u0003\t\u0005!V\u000by\u0001E\u0002712Daa\u0017\u0007A\u0002\u0005=!AB%t\u001dVdG.\u0006\u0003\u0002\u0018\u0005u1cA\u0007\u0002\u001aA!A\bAA\u000e!\r\u0001\u0015Q\u0004\u0003\u0006\u00056\u0011\ra\u0011\u000b\u0003\u0003C\u0001B\u0001_\u0007\u0002\u001cQ!\u0011QEA\u0015!\u0011\u0001V+a\n\u0011\tYB\u00161\u0004\u0005\u00077B\u0001\r!a\n\u0003\u00079{G/\u0006\u0003\u00020\u0005U2cA\t\u00022A!A\bAA\u001a!\r\u0001\u0015Q\u0007\u0003\u0006\u0005F\u0011\ra\u0011\t\u0005cR\f\u0019\u0004\u0006\u0004\u0002<\u0005u\u0012q\b\t\u0005qF\t\u0019\u0004\u0003\u0004o)\u0001\u0007\u00111\u0007\u0005\u0007_R\u0001\r!a\u000e\u0015\t\u0005\r\u0013q\t\t\u0005!V\u000b)\u0005\u0005\u000371\u0006M\u0002BB.\u0017\u0001\u0004\t)EA\u0004O_RtU\u000f\u001c7\u0016\t\u00055\u00131K\n\u0004/\u0005=\u0003\u0003\u0002\u001f\u0001\u0003#\u00022\u0001QA*\t\u0015\u0011uC1\u0001D)\t\t9\u0006\u0005\u0003y/\u0005EC\u0003BA.\u0003?\u0002B\u0001U+\u0002^A!a\u0007WA)\u0011\u0019Y&\u00041\u0001\u0002^\t\u0011\u0011J\\\u000b\u0005\u0003K\nYgE\u0002\u001c\u0003O\u0002B\u0001\u0010\u0001\u0002jA\u0019\u0001)a\u001b\u0005\u000b\t[\"\u0019A\"\u0011\r\u0005=\u0014qPA5\u001d\u0011\t\t(a\u001f\u000f\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e3\u0003\u0019a$o\\8u}%\t\u0001(C\u0002\u0002~]\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%aA*fc*\u0019\u0011QP\u001c\u0015\t\u0005\u001d\u0015\u0011\u0012\t\u0005qn\tI\u0007\u0003\u0004o;\u0001\u0007\u0011QN\u000b\u0003\u0003\u001b\u0003B!a$\u0002\u0018:!\u0011\u0011SAJ!\r\t\u0019hN\u0005\u0004\u0003+;\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005e%bAAKoQ!\u0011QTAQ!\u0011\u0001V+a(\u0011\tYB\u0016\u0011\u000e\u0005\u00077~\u0001\r!a(\u0003\u000f\r{W\u000e]1sKV!\u0011qUAW'\r\u0001\u0013\u0011\u0016\t\u0005y\u0001\tY\u000bE\u0002A\u0003[#QA\u0011\u0011C\u0002\r\u000babY8na\u0006\u0014\u0018n]8o\u001d\u0006lW-A\bd_6\u0004\u0018M]5t_:t\u0015-\\3!\u0003\u001diWm]:bO\u0016\fqaY8na\u0006\u0014X\r\u0005\u00057\u0003s\u000bY+a+b\u0013\r\tYl\u000e\u0002\n\rVt7\r^5p]J\"\"\"a0\u0002B\u0006\r\u0017QYAd!\u0011A\b%a+\t\u000f\u0005=f\u00051\u0001\u0002\u000e\"9\u00111\u0017\u0014A\u0002\u00055\u0005bBA[M\u0001\u0007\u0011q\u0017\u0005\u0007]\u001a\u0002\r!a+\u0015\t\u0005-\u0017q\u001a\t\u0005!V\u000bi\r\u0005\u000371\u0006-\u0006BB.)\u0001\u0004\ti\r")
public abstract class Matcher<A>
implements Validator<A> {
    public abstract Validation<Option<A>> doMatch(Option<A> var1);

    @Override
    public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
        if (displayActualValue) {
            return this.doMatch(actual).mapFailure((Function1 & Serializable)message -> "but actually " + message);
        }
        return this.doMatch(actual);
    }

    public static final class Compare<A>
    extends Matcher<A> {
        private final String comparisonName;
        private final String message;
        private final Function2<A, A, Object> compare;
        private final A expected;

        public String comparisonName() {
            return this.comparisonName;
        }

        @Override
        public String name() {
            return this.comparisonName() + "(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (BoxesRunTime.unboxToBoolean((Object)this.compare.apply(actualValue, this.expected))) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(actualValue + " is not " + this.message + " " + this.expected));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("can't compare nothing and " + this.expected));
        }

        public Compare(String comparisonName, String message, Function2<A, A, Object> compare, A expected) {
            this.comparisonName = comparisonName;
            this.message = message;
            this.compare = compare;
            this.expected = expected;
        }
    }

    public static final class In<A>
    extends Matcher<A> {
        private final Seq<A> expected;

        @Override
        public String name() {
            Seq<A> seq = this.expected;
            if (seq instanceof Range) {
                Range range = (Range)seq;
                return "in(" + range.toString() + ")";
            }
            return this.expected.mkString("in(", ",", ")");
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.expected.contains(actualValue)) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }

        public In(Seq<A> expected) {
            this.expected = expected;
        }
    }

    public static final class Is<A>
    extends Matcher<A> {
        private final A expected;
        private final Equality<A> equality;

        @Override
        public String name() {
            return "is(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.equality.equals(actualValue, this.expected)) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }

        public Is(A expected, Equality<A> equality) {
            this.expected = expected;
            this.equality = equality;
        }
    }

    public static final class IsNull<A>
    extends Matcher<A> {
        @Override
        public String name() {
            return "isNull";
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (actualValue == null) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }
    }

    public static final class Not<A>
    extends Matcher<A> {
        private final A expected;
        private final Equality<A> equality;

        @Override
        public String name() {
            return "not(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.equality.equals(actualValue, this.expected)) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("unexpectedly found " + actualValue));
                }
                return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
            }
            return Validation$.MODULE$.NoneSuccess();
        }

        public Not(A expected, Equality<A> equality) {
            this.expected = expected;
            this.equality = equality;
        }
    }

    public static final class NotNull<A>
    extends Matcher<A> {
        @Override
        public String name() {
            return "notNull";
        }

        @Override
        public Validation<Option<A>> doMatch(Option<A> actual) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (actualValue == null) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found null"));
                }
                return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }
    }
}

