/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.EgressIPConfig;
import io.fabric8.openshift.api.model.operator.v1.EgressIPConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.EgressIPConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.GatewayConfig;
import io.fabric8.openshift.api.model.operator.v1.GatewayConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.GatewayConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.IPsecConfig;
import io.fabric8.openshift.api.model.operator.v1.IPsecConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.IPsecConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.IPv4OVNKubernetesConfig;
import io.fabric8.openshift.api.model.operator.v1.IPv4OVNKubernetesConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.IPv4OVNKubernetesConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.IPv6OVNKubernetesConfig;
import io.fabric8.openshift.api.model.operator.v1.IPv6OVNKubernetesConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.IPv6OVNKubernetesConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.OVNKubernetesConfig;
import io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig;
import io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OVNKubernetesConfigFluent<A extends OVNKubernetesConfigFluent<A>>
extends BaseFluent<A> {
    private EgressIPConfigBuilder egressIPConfig;
    private GatewayConfigBuilder gatewayConfig;
    private Long genevePort;
    private HybridOverlayConfigBuilder hybridOverlayConfig;
    private IPsecConfigBuilder ipsecConfig;
    private IPv4OVNKubernetesConfigBuilder ipv4;
    private IPv6OVNKubernetesConfigBuilder ipv6;
    private Long mtu;
    private PolicyAuditConfigBuilder policyAuditConfig;
    private String routeAdvertisements;
    private String v4InternalSubnet;
    private String v6InternalSubnet;
    private Map<String, Object> additionalProperties;

    public OVNKubernetesConfigFluent() {
    }

    public OVNKubernetesConfigFluent(OVNKubernetesConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OVNKubernetesConfig instance) {
        OVNKubernetesConfig oVNKubernetesConfig = instance = instance != null ? instance : new OVNKubernetesConfig();
        if (instance != null) {
            this.withEgressIPConfig(instance.getEgressIPConfig());
            this.withGatewayConfig(instance.getGatewayConfig());
            this.withGenevePort(instance.getGenevePort());
            this.withHybridOverlayConfig(instance.getHybridOverlayConfig());
            this.withIpsecConfig(instance.getIpsecConfig());
            this.withIpv4(instance.getIpv4());
            this.withIpv6(instance.getIpv6());
            this.withMtu(instance.getMtu());
            this.withPolicyAuditConfig(instance.getPolicyAuditConfig());
            this.withRouteAdvertisements(instance.getRouteAdvertisements());
            this.withV4InternalSubnet(instance.getV4InternalSubnet());
            this.withV6InternalSubnet(instance.getV6InternalSubnet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EgressIPConfig buildEgressIPConfig() {
        return this.egressIPConfig != null ? this.egressIPConfig.build() : null;
    }

    public A withEgressIPConfig(EgressIPConfig egressIPConfig) {
        this._visitables.remove((Object)"egressIPConfig");
        if (egressIPConfig != null) {
            this.egressIPConfig = new EgressIPConfigBuilder(egressIPConfig);
            this._visitables.get((Object)"egressIPConfig").add(this.egressIPConfig);
        } else {
            this.egressIPConfig = null;
            this._visitables.get((Object)"egressIPConfig").remove((Object)this.egressIPConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasEgressIPConfig() {
        return this.egressIPConfig != null;
    }

    public A withNewEgressIPConfig(Long reachabilityTotalTimeoutSeconds) {
        return this.withEgressIPConfig(new EgressIPConfig(reachabilityTotalTimeoutSeconds));
    }

    public EgressIPConfigNested<A> withNewEgressIPConfig() {
        return new EgressIPConfigNested(null);
    }

    public EgressIPConfigNested<A> withNewEgressIPConfigLike(EgressIPConfig item) {
        return new EgressIPConfigNested(item);
    }

    public EgressIPConfigNested<A> editEgressIPConfig() {
        return this.withNewEgressIPConfigLike(Optional.ofNullable(this.buildEgressIPConfig()).orElse(null));
    }

    public EgressIPConfigNested<A> editOrNewEgressIPConfig() {
        return this.withNewEgressIPConfigLike(Optional.ofNullable(this.buildEgressIPConfig()).orElse(new EgressIPConfigBuilder().build()));
    }

    public EgressIPConfigNested<A> editOrNewEgressIPConfigLike(EgressIPConfig item) {
        return this.withNewEgressIPConfigLike(Optional.ofNullable(this.buildEgressIPConfig()).orElse(item));
    }

    public GatewayConfig buildGatewayConfig() {
        return this.gatewayConfig != null ? this.gatewayConfig.build() : null;
    }

    public A withGatewayConfig(GatewayConfig gatewayConfig) {
        this._visitables.remove((Object)"gatewayConfig");
        if (gatewayConfig != null) {
            this.gatewayConfig = new GatewayConfigBuilder(gatewayConfig);
            this._visitables.get((Object)"gatewayConfig").add(this.gatewayConfig);
        } else {
            this.gatewayConfig = null;
            this._visitables.get((Object)"gatewayConfig").remove((Object)this.gatewayConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasGatewayConfig() {
        return this.gatewayConfig != null;
    }

    public GatewayConfigNested<A> withNewGatewayConfig() {
        return new GatewayConfigNested(null);
    }

    public GatewayConfigNested<A> withNewGatewayConfigLike(GatewayConfig item) {
        return new GatewayConfigNested(item);
    }

    public GatewayConfigNested<A> editGatewayConfig() {
        return this.withNewGatewayConfigLike(Optional.ofNullable(this.buildGatewayConfig()).orElse(null));
    }

    public GatewayConfigNested<A> editOrNewGatewayConfig() {
        return this.withNewGatewayConfigLike(Optional.ofNullable(this.buildGatewayConfig()).orElse(new GatewayConfigBuilder().build()));
    }

    public GatewayConfigNested<A> editOrNewGatewayConfigLike(GatewayConfig item) {
        return this.withNewGatewayConfigLike(Optional.ofNullable(this.buildGatewayConfig()).orElse(item));
    }

    public Long getGenevePort() {
        return this.genevePort;
    }

    public A withGenevePort(Long genevePort) {
        this.genevePort = genevePort;
        return (A)((Object)this);
    }

    public boolean hasGenevePort() {
        return this.genevePort != null;
    }

    public HybridOverlayConfig buildHybridOverlayConfig() {
        return this.hybridOverlayConfig != null ? this.hybridOverlayConfig.build() : null;
    }

    public A withHybridOverlayConfig(HybridOverlayConfig hybridOverlayConfig) {
        this._visitables.remove((Object)"hybridOverlayConfig");
        if (hybridOverlayConfig != null) {
            this.hybridOverlayConfig = new HybridOverlayConfigBuilder(hybridOverlayConfig);
            this._visitables.get((Object)"hybridOverlayConfig").add(this.hybridOverlayConfig);
        } else {
            this.hybridOverlayConfig = null;
            this._visitables.get((Object)"hybridOverlayConfig").remove((Object)this.hybridOverlayConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasHybridOverlayConfig() {
        return this.hybridOverlayConfig != null;
    }

    public HybridOverlayConfigNested<A> withNewHybridOverlayConfig() {
        return new HybridOverlayConfigNested(null);
    }

    public HybridOverlayConfigNested<A> withNewHybridOverlayConfigLike(HybridOverlayConfig item) {
        return new HybridOverlayConfigNested(item);
    }

    public HybridOverlayConfigNested<A> editHybridOverlayConfig() {
        return this.withNewHybridOverlayConfigLike(Optional.ofNullable(this.buildHybridOverlayConfig()).orElse(null));
    }

    public HybridOverlayConfigNested<A> editOrNewHybridOverlayConfig() {
        return this.withNewHybridOverlayConfigLike(Optional.ofNullable(this.buildHybridOverlayConfig()).orElse(new HybridOverlayConfigBuilder().build()));
    }

    public HybridOverlayConfigNested<A> editOrNewHybridOverlayConfigLike(HybridOverlayConfig item) {
        return this.withNewHybridOverlayConfigLike(Optional.ofNullable(this.buildHybridOverlayConfig()).orElse(item));
    }

    public IPsecConfig buildIpsecConfig() {
        return this.ipsecConfig != null ? this.ipsecConfig.build() : null;
    }

    public A withIpsecConfig(IPsecConfig ipsecConfig) {
        this._visitables.remove((Object)"ipsecConfig");
        if (ipsecConfig != null) {
            this.ipsecConfig = new IPsecConfigBuilder(ipsecConfig);
            this._visitables.get((Object)"ipsecConfig").add(this.ipsecConfig);
        } else {
            this.ipsecConfig = null;
            this._visitables.get((Object)"ipsecConfig").remove((Object)this.ipsecConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasIpsecConfig() {
        return this.ipsecConfig != null;
    }

    public A withNewIpsecConfig(String mode) {
        return this.withIpsecConfig(new IPsecConfig(mode));
    }

    public IpsecConfigNested<A> withNewIpsecConfig() {
        return new IpsecConfigNested(null);
    }

    public IpsecConfigNested<A> withNewIpsecConfigLike(IPsecConfig item) {
        return new IpsecConfigNested(item);
    }

    public IpsecConfigNested<A> editIpsecConfig() {
        return this.withNewIpsecConfigLike(Optional.ofNullable(this.buildIpsecConfig()).orElse(null));
    }

    public IpsecConfigNested<A> editOrNewIpsecConfig() {
        return this.withNewIpsecConfigLike(Optional.ofNullable(this.buildIpsecConfig()).orElse(new IPsecConfigBuilder().build()));
    }

    public IpsecConfigNested<A> editOrNewIpsecConfigLike(IPsecConfig item) {
        return this.withNewIpsecConfigLike(Optional.ofNullable(this.buildIpsecConfig()).orElse(item));
    }

    public IPv4OVNKubernetesConfig buildIpv4() {
        return this.ipv4 != null ? this.ipv4.build() : null;
    }

    public A withIpv4(IPv4OVNKubernetesConfig ipv4) {
        this._visitables.remove((Object)"ipv4");
        if (ipv4 != null) {
            this.ipv4 = new IPv4OVNKubernetesConfigBuilder(ipv4);
            this._visitables.get((Object)"ipv4").add(this.ipv4);
        } else {
            this.ipv4 = null;
            this._visitables.get((Object)"ipv4").remove((Object)this.ipv4);
        }
        return (A)((Object)this);
    }

    public boolean hasIpv4() {
        return this.ipv4 != null;
    }

    public A withNewIpv4(String internalJoinSubnet, String internalTransitSwitchSubnet) {
        return this.withIpv4(new IPv4OVNKubernetesConfig(internalJoinSubnet, internalTransitSwitchSubnet));
    }

    public Ipv4Nested<A> withNewIpv4() {
        return new Ipv4Nested(null);
    }

    public Ipv4Nested<A> withNewIpv4Like(IPv4OVNKubernetesConfig item) {
        return new Ipv4Nested(item);
    }

    public Ipv4Nested<A> editIpv4() {
        return this.withNewIpv4Like(Optional.ofNullable(this.buildIpv4()).orElse(null));
    }

    public Ipv4Nested<A> editOrNewIpv4() {
        return this.withNewIpv4Like(Optional.ofNullable(this.buildIpv4()).orElse(new IPv4OVNKubernetesConfigBuilder().build()));
    }

    public Ipv4Nested<A> editOrNewIpv4Like(IPv4OVNKubernetesConfig item) {
        return this.withNewIpv4Like(Optional.ofNullable(this.buildIpv4()).orElse(item));
    }

    public IPv6OVNKubernetesConfig buildIpv6() {
        return this.ipv6 != null ? this.ipv6.build() : null;
    }

    public A withIpv6(IPv6OVNKubernetesConfig ipv6) {
        this._visitables.remove((Object)"ipv6");
        if (ipv6 != null) {
            this.ipv6 = new IPv6OVNKubernetesConfigBuilder(ipv6);
            this._visitables.get((Object)"ipv6").add(this.ipv6);
        } else {
            this.ipv6 = null;
            this._visitables.get((Object)"ipv6").remove((Object)this.ipv6);
        }
        return (A)((Object)this);
    }

    public boolean hasIpv6() {
        return this.ipv6 != null;
    }

    public A withNewIpv6(String internalJoinSubnet, String internalTransitSwitchSubnet) {
        return this.withIpv6(new IPv6OVNKubernetesConfig(internalJoinSubnet, internalTransitSwitchSubnet));
    }

    public Ipv6Nested<A> withNewIpv6() {
        return new Ipv6Nested(null);
    }

    public Ipv6Nested<A> withNewIpv6Like(IPv6OVNKubernetesConfig item) {
        return new Ipv6Nested(item);
    }

    public Ipv6Nested<A> editIpv6() {
        return this.withNewIpv6Like(Optional.ofNullable(this.buildIpv6()).orElse(null));
    }

    public Ipv6Nested<A> editOrNewIpv6() {
        return this.withNewIpv6Like(Optional.ofNullable(this.buildIpv6()).orElse(new IPv6OVNKubernetesConfigBuilder().build()));
    }

    public Ipv6Nested<A> editOrNewIpv6Like(IPv6OVNKubernetesConfig item) {
        return this.withNewIpv6Like(Optional.ofNullable(this.buildIpv6()).orElse(item));
    }

    public Long getMtu() {
        return this.mtu;
    }

    public A withMtu(Long mtu) {
        this.mtu = mtu;
        return (A)((Object)this);
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public PolicyAuditConfig buildPolicyAuditConfig() {
        return this.policyAuditConfig != null ? this.policyAuditConfig.build() : null;
    }

    public A withPolicyAuditConfig(PolicyAuditConfig policyAuditConfig) {
        this._visitables.remove((Object)"policyAuditConfig");
        if (policyAuditConfig != null) {
            this.policyAuditConfig = new PolicyAuditConfigBuilder(policyAuditConfig);
            this._visitables.get((Object)"policyAuditConfig").add(this.policyAuditConfig);
        } else {
            this.policyAuditConfig = null;
            this._visitables.get((Object)"policyAuditConfig").remove((Object)this.policyAuditConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasPolicyAuditConfig() {
        return this.policyAuditConfig != null;
    }

    public A withNewPolicyAuditConfig(String destination, Long maxFileSize, Integer maxLogFiles, Long rateLimit, String syslogFacility) {
        return this.withPolicyAuditConfig(new PolicyAuditConfig(destination, maxFileSize, maxLogFiles, rateLimit, syslogFacility));
    }

    public PolicyAuditConfigNested<A> withNewPolicyAuditConfig() {
        return new PolicyAuditConfigNested(null);
    }

    public PolicyAuditConfigNested<A> withNewPolicyAuditConfigLike(PolicyAuditConfig item) {
        return new PolicyAuditConfigNested(item);
    }

    public PolicyAuditConfigNested<A> editPolicyAuditConfig() {
        return this.withNewPolicyAuditConfigLike(Optional.ofNullable(this.buildPolicyAuditConfig()).orElse(null));
    }

    public PolicyAuditConfigNested<A> editOrNewPolicyAuditConfig() {
        return this.withNewPolicyAuditConfigLike(Optional.ofNullable(this.buildPolicyAuditConfig()).orElse(new PolicyAuditConfigBuilder().build()));
    }

    public PolicyAuditConfigNested<A> editOrNewPolicyAuditConfigLike(PolicyAuditConfig item) {
        return this.withNewPolicyAuditConfigLike(Optional.ofNullable(this.buildPolicyAuditConfig()).orElse(item));
    }

    public String getRouteAdvertisements() {
        return this.routeAdvertisements;
    }

    public A withRouteAdvertisements(String routeAdvertisements) {
        this.routeAdvertisements = routeAdvertisements;
        return (A)((Object)this);
    }

    public boolean hasRouteAdvertisements() {
        return this.routeAdvertisements != null;
    }

    public String getV4InternalSubnet() {
        return this.v4InternalSubnet;
    }

    public A withV4InternalSubnet(String v4InternalSubnet) {
        this.v4InternalSubnet = v4InternalSubnet;
        return (A)((Object)this);
    }

    public boolean hasV4InternalSubnet() {
        return this.v4InternalSubnet != null;
    }

    public String getV6InternalSubnet() {
        return this.v6InternalSubnet;
    }

    public A withV6InternalSubnet(String v6InternalSubnet) {
        this.v6InternalSubnet = v6InternalSubnet;
        return (A)((Object)this);
    }

    public boolean hasV6InternalSubnet() {
        return this.v6InternalSubnet != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OVNKubernetesConfigFluent that = (OVNKubernetesConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.egressIPConfig, (Object)that.egressIPConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.gatewayConfig, (Object)that.gatewayConfig)) {
            return false;
        }
        if (!Objects.equals(this.genevePort, that.genevePort)) {
            return false;
        }
        if (!Objects.equals((Object)this.hybridOverlayConfig, (Object)that.hybridOverlayConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.ipsecConfig, (Object)that.ipsecConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.ipv4, (Object)that.ipv4)) {
            return false;
        }
        if (!Objects.equals((Object)this.ipv6, (Object)that.ipv6)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        if (!Objects.equals((Object)this.policyAuditConfig, (Object)that.policyAuditConfig)) {
            return false;
        }
        if (!Objects.equals(this.routeAdvertisements, that.routeAdvertisements)) {
            return false;
        }
        if (!Objects.equals(this.v4InternalSubnet, that.v4InternalSubnet)) {
            return false;
        }
        if (!Objects.equals(this.v6InternalSubnet, that.v6InternalSubnet)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.egressIPConfig, this.gatewayConfig, this.genevePort, this.hybridOverlayConfig, this.ipsecConfig, this.ipv4, this.ipv6, this.mtu, this.policyAuditConfig, this.routeAdvertisements, this.v4InternalSubnet, this.v6InternalSubnet, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egressIPConfig != null) {
            sb.append("egressIPConfig:");
            sb.append(String.valueOf((Object)this.egressIPConfig) + ",");
        }
        if (this.gatewayConfig != null) {
            sb.append("gatewayConfig:");
            sb.append(String.valueOf((Object)this.gatewayConfig) + ",");
        }
        if (this.genevePort != null) {
            sb.append("genevePort:");
            sb.append(this.genevePort + ",");
        }
        if (this.hybridOverlayConfig != null) {
            sb.append("hybridOverlayConfig:");
            sb.append(String.valueOf((Object)this.hybridOverlayConfig) + ",");
        }
        if (this.ipsecConfig != null) {
            sb.append("ipsecConfig:");
            sb.append(String.valueOf((Object)this.ipsecConfig) + ",");
        }
        if (this.ipv4 != null) {
            sb.append("ipv4:");
            sb.append(String.valueOf((Object)this.ipv4) + ",");
        }
        if (this.ipv6 != null) {
            sb.append("ipv6:");
            sb.append(String.valueOf((Object)this.ipv6) + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.policyAuditConfig != null) {
            sb.append("policyAuditConfig:");
            sb.append(String.valueOf((Object)this.policyAuditConfig) + ",");
        }
        if (this.routeAdvertisements != null) {
            sb.append("routeAdvertisements:");
            sb.append(this.routeAdvertisements + ",");
        }
        if (this.v4InternalSubnet != null) {
            sb.append("v4InternalSubnet:");
            sb.append(this.v4InternalSubnet + ",");
        }
        if (this.v6InternalSubnet != null) {
            sb.append("v6InternalSubnet:");
            sb.append(this.v6InternalSubnet + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PolicyAuditConfigNested<N>
    extends PolicyAuditConfigFluent<PolicyAuditConfigNested<N>>
    implements Nested<N> {
        PolicyAuditConfigBuilder builder;

        PolicyAuditConfigNested(PolicyAuditConfig item) {
            this.builder = new PolicyAuditConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withPolicyAuditConfig(this.builder.build());
        }

        public N endPolicyAuditConfig() {
            return this.and();
        }
    }

    public class Ipv6Nested<N>
    extends IPv6OVNKubernetesConfigFluent<Ipv6Nested<N>>
    implements Nested<N> {
        IPv6OVNKubernetesConfigBuilder builder;

        Ipv6Nested(IPv6OVNKubernetesConfig item) {
            this.builder = new IPv6OVNKubernetesConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withIpv6(this.builder.build());
        }

        public N endIpv6() {
            return this.and();
        }
    }

    public class Ipv4Nested<N>
    extends IPv4OVNKubernetesConfigFluent<Ipv4Nested<N>>
    implements Nested<N> {
        IPv4OVNKubernetesConfigBuilder builder;

        Ipv4Nested(IPv4OVNKubernetesConfig item) {
            this.builder = new IPv4OVNKubernetesConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withIpv4(this.builder.build());
        }

        public N endIpv4() {
            return this.and();
        }
    }

    public class IpsecConfigNested<N>
    extends IPsecConfigFluent<IpsecConfigNested<N>>
    implements Nested<N> {
        IPsecConfigBuilder builder;

        IpsecConfigNested(IPsecConfig item) {
            this.builder = new IPsecConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withIpsecConfig(this.builder.build());
        }

        public N endIpsecConfig() {
            return this.and();
        }
    }

    public class HybridOverlayConfigNested<N>
    extends HybridOverlayConfigFluent<HybridOverlayConfigNested<N>>
    implements Nested<N> {
        HybridOverlayConfigBuilder builder;

        HybridOverlayConfigNested(HybridOverlayConfig item) {
            this.builder = new HybridOverlayConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withHybridOverlayConfig(this.builder.build());
        }

        public N endHybridOverlayConfig() {
            return this.and();
        }
    }

    public class GatewayConfigNested<N>
    extends GatewayConfigFluent<GatewayConfigNested<N>>
    implements Nested<N> {
        GatewayConfigBuilder builder;

        GatewayConfigNested(GatewayConfig item) {
            this.builder = new GatewayConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withGatewayConfig(this.builder.build());
        }

        public N endGatewayConfig() {
            return this.and();
        }
    }

    public class EgressIPConfigNested<N>
    extends EgressIPConfigFluent<EgressIPConfigNested<N>>
    implements Nested<N> {
        EgressIPConfigBuilder builder;

        EgressIPConfigNested(EgressIPConfig item) {
            this.builder = new EgressIPConfigBuilder(this, item);
        }

        public N and() {
            return (N)OVNKubernetesConfigFluent.this.withEgressIPConfig(this.builder.build());
        }

        public N endEgressIPConfig() {
            return this.and();
        }
    }
}

