/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.LineageReducer;
import io.cucumber.teamcityformatter.LineageNode;
import java.util.ArrayList;
import java.util.List;

final class PathCollector
implements LineageReducer.Collector<List<LineageNode>> {
    private final List<LineageNode> lineage = new ArrayList<LineageNode>(5);
    private String uri;
    private String scenarioName;
    private int examplesIndex;
    private boolean isExample;

    PathCollector() {
    }

    public void add(GherkinDocument document) {
        this.uri = document.getUri().orElse("");
    }

    public void add(Feature feature) {
        String name = PathCollector.getNameOrKeyword(feature.getName(), feature.getKeyword());
        this.lineage.add(new LineageNode(name, this.uri, feature.getLocation()));
    }

    public void add(Rule rule) {
        String name = PathCollector.getNameOrKeyword(rule.getName(), rule.getKeyword());
        this.lineage.add(new LineageNode(name, this.uri, rule.getLocation()));
    }

    public void add(Scenario scenario) {
        String name = PathCollector.getNameOrKeyword(scenario.getName(), scenario.getKeyword());
        this.lineage.add(new LineageNode(name, this.uri, scenario.getLocation()));
        this.scenarioName = name;
    }

    public void add(Examples examples, int index) {
        String name = PathCollector.getNameOrKeyword(examples.getName(), examples.getKeyword());
        this.lineage.add(new LineageNode(name, this.uri, examples.getLocation()));
        this.examplesIndex = index;
    }

    public void add(TableRow example, int index) {
        this.isExample = true;
        String name = "#" + (this.examplesIndex + 1) + "." + (index + 1);
        this.lineage.add(new LineageNode(name, this.uri, example.getLocation()));
    }

    public void add(Pickle pickle) {
        if (this.isExample) {
            boolean parameterized;
            String pickleName = pickle.getName();
            boolean bl = parameterized = !this.scenarioName.equals(pickleName);
            if (parameterized) {
                LineageNode example = this.lineage.remove(this.lineage.size() - 1);
                String parameterizedExampleName = example.getName() + ": " + pickleName;
                this.lineage.add(new LineageNode(parameterizedExampleName, example.getUri(), example.getLocation()));
            }
        }
    }

    public List<LineageNode> finish() {
        return this.lineage;
    }

    private static String getNameOrKeyword(String name, String keyword) {
        if (!name.isEmpty()) {
            return name;
        }
        if (!keyword.isEmpty()) {
            return keyword;
        }
        return "Unknown";
    }
}

