/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import java.util.ArrayList;
import java.util.List;
import org.vaadin.firitin.element.svg.SvgGraphicsElement;

public class PolylineElement
extends SvgGraphicsElement {
    private final List<double[]> pointsList = new ArrayList<double[]>();

    public PolylineElement() {
        super("polyline");
    }

    public PolylineElement points(String points) {
        this.pointsList.clear();
        this.setWriteOnlyAttribute("points", points);
        return this;
    }

    public PolylineElement pointsRW(String points) {
        this.pointsList.clear();
        this.setAttribute("points", points);
        return this;
    }

    public PolylineElement points(double ... coords) {
        if (coords.length % 2 != 0) {
            throw new IllegalArgumentException("Coordinates must be provided in pairs (x,y)");
        }
        this.pointsList.clear();
        for (int i = 0; i < coords.length; i += 2) {
            this.pointsList.add(new double[]{coords[i], coords[i + 1]});
        }
        this.updatePointsAttribute();
        return this;
    }

    public PolylineElement addPoint(double x, double y) {
        this.pointsList.add(new double[]{x, y});
        this.updatePointsAttribute();
        return this;
    }

    public PolylineElement addPoints(double ... coords) {
        if (coords.length % 2 != 0) {
            throw new IllegalArgumentException("Coordinates must be provided in pairs (x,y)");
        }
        for (int i = 0; i < coords.length; i += 2) {
            this.pointsList.add(new double[]{coords[i], coords[i + 1]});
        }
        this.updatePointsAttribute();
        return this;
    }

    public PolylineElement clearPoints() {
        this.pointsList.clear();
        this.setWriteOnlyAttribute("points", "");
        return this;
    }

    public PolylineElement pathLength(double pathLength) {
        this.setWriteOnlyAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    public PolylineElement pathLengthRW(double pathLength) {
        this.setAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    private void updatePointsAttribute() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pointsList.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            double[] point = this.pointsList.get(i);
            sb.append(point[0]).append(",").append(point[1]);
        }
        this.setWriteOnlyAttribute("points", sb.toString());
    }
}

