/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.entities.user.JdbcConfiguration;
import fr.ird.t3.entities.user.JdbcConfigurationImpl;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.web.actions.T3ActionSupport;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectUserT3DatabaseAction
extends T3ActionSupport
implements Preparable {
    protected static final Log log = LogFactory.getLog(SelectUserT3DatabaseAction.class);
    private static final long serialVersionUID = 1L;
    protected String databaseId;
    protected JdbcConfiguration database;
    protected Map<String, String> databases;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public JdbcConfiguration getDatabase() {
        if (this.database == null) {
            this.database = new JdbcConfigurationImpl();
        }
        return this.database;
    }

    public Map<String, String> getDatabases() {
        return this.databases;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public void prepare() throws Exception {
        T3User user = this.getT3Session().getUser();
        user = this.getUserService().getUserById(user.getTopiaId());
        Collection dbs = user.getUserT3Database();
        if (CollectionUtils.isEmpty((Collection)dbs)) {
            this.databases = Maps.newHashMap();
            this.addActionMessage(this._("t3.message.no.t3.database.registred", new Object[0]));
        } else {
            this.databases = this.sortAndDecorate(dbs);
        }
    }

    public String execute() throws Exception {
        this.getT3Session().initDatabaseConfiguration(this.getDatabase());
        return "success";
    }
}

