/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.validators;

import com.google.common.collect.ArrayListMultimap;
import com.opensymphony.xwork2.validator.ValidationException;
import fr.ird.t3.actions.data.level0.Level0Step;
import fr.ird.t3.actions.data.level1.Level1Configuration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.web.validators.T3BaseFieldValidatorSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuiton.util.decorator.Decorator;

public class Level1ConfigurationFieldValidator
extends T3BaseFieldValidatorSupport {
    protected void validateWhenNotSkip(Object object) throws ValidationException {
        if (this.getValidatorContext().hasFieldErrors()) {
            return;
        }
        Level1Configuration configuration = (Level1Configuration)this.getFieldValue("configuration", object);
        Map tripByTopiaIds = (Map)this.getFieldValue("tripByTopiaIds", object);
        Set tripIds = configuration.getSampleIdsByTripId().keySet();
        Decorator decoratorByType = (Decorator)this.getFieldValue("tripDecorator", object);
        Level0Step[] level0Steps = Level0Step.values();
        ArrayListMultimap m = ArrayListMultimap.create();
        for (String tripId : tripIds) {
            Trip trip = (Trip)tripByTopiaIds.get(tripId);
            if (trip.isSamplesOnly()) continue;
            String key = decoratorByType.toString((Object)trip);
            for (Level0Step level0Step : level0Steps) {
                boolean tripState = level0Step.getTripState(trip);
                if (tripState) continue;
                m.put((Object)key, (Object)level0Step);
            }
        }
        if (!m.isEmpty()) {
            for (String tripStr : m.keySet()) {
                Collection steps = m.get((Object)tripStr);
                this.addFieldError("matchingTripCount", this._("t3.error.missing.level0.steps.for.trip", new Object[]{tripStr, steps}));
            }
        }
    }

    public String getValidatorType() {
        return "level1Configuration";
    }
}

