/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import fr.ird.t3.web.T3Session;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

public class T3UserTransactionFilter
extends TopiaTransactionFilter {
    private static final Log log = LogFactory.getLog(T3UserTransactionFilter.class);
    public static final String USER_TRANSACTION = "userTransaction";

    public static TopiaContext getTransaction(ServletRequest request) {
        TopiaContext topiaContext = (TopiaContext)request.getAttribute(USER_TRANSACTION);
        return topiaContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.setRequestAttributeName(USER_TRANSACTION);
    }

    public TopiaContext beginTransaction(ServletRequest request) {
        HttpSession session = ((HttpServletRequest)request).getSession();
        T3Session t3Session = T3Session.getT3Session((HttpSession)session);
        TopiaContext rootContext = t3Session.getRootContext();
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts a new t3 transaction " + transaction));
            }
            return transaction;
        }
        catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", (Throwable)eee);
        }
    }
}

