/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ird.t3.entities.T3Functions;
import fr.ird.t3.entities.data.Activity;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.T3ActionSupport;
import fr.ird.t3.web.actions.admin.TripListModel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.util.decorator.Decorator;

public class T3DatabaseDetailAction
extends T3ActionSupport {
    private static final long serialVersionUID = -8408617621456216934L;
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    protected transient Multimap<Ocean, Trip> tripsByOcean;
    protected List<Ocean> oceans;
    protected long nbTrips;
    @InjectFromDAO(entityType=Activity.class, method="count")
    protected long nbActivities;
    protected TripListModel tripListModel;

    public TripListModel getTripListModel() {
        if (this.tripListModel == null) {
            this.tripListModel = this.getT3Session().getTripListModel();
            if (this.tripListModel == null) {
                this.tripListModel = new TripListModel();
            }
        }
        return this.tripListModel;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class, InjectFromDAO.class});
        this.tripListModel = this.getT3Session().getTripListModel() == null ? this.loadTripListModel(this.tripDAO) : this.getT3Session().getTripListModel();
        this.oceans = this.tripListModel.getOceans();
        this.tripsByOcean = ArrayListMultimap.create();
        for (Ocean ocean : this.oceans) {
            List ids = (List)this.tripListModel.getTripIds(ocean);
            List trips = this.tripDAO.findAllByIds(ids);
            this.tripsByOcean.putAll((Object)ocean, (Iterable)trips);
        }
        this.nbTrips = this.tripListModel.getTripIdsByOcean().values().size();
        return "input";
    }

    public List<Ocean> getOceans() {
        return this.oceans;
    }

    public long getNbTrips() {
        return this.nbTrips;
    }

    public long getNbActivities() {
        return this.nbActivities;
    }

    public long getNbActivities(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        long result = 0L;
        for (Trip trip : trips) {
            result += (long)trip.sizeActivity();
        }
        return result;
    }

    public int getNbOceans() {
        return this.getOceans().size();
    }

    public int getNbTrips(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        return trips.size();
    }

    public String getFirstTripDate(Ocean ocean) {
        List trips = (List)this.getTrips(ocean);
        Trip trip = (Trip)trips.get(0);
        return this.formatDate(trip.getLandingDate());
    }

    public String getLastTripDate(Ocean ocean) {
        List trips = (List)this.getTrips(ocean);
        Trip trip = (Trip)trips.get(trips.size() - 1);
        return this.formatDate(trip.getLandingDate());
    }

    public Map<String, String> getTripsWithNoDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithNoDataComputed((Collection)trips);
        Map result = this.getTripMap(filtredTrips);
        return result;
    }

    public Map<String, String> getTripsWithSomeDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithSomeDataComputed((Collection)trips);
        Map result = this.getTripMap(filtredTrips);
        return result;
    }

    public Map<String, String> getTripsWithAllDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithAllDataComputed((Collection)trips);
        Map result = this.getTripMap(filtredTrips);
        return result;
    }

    protected Collection<Trip> getTrips(Ocean ocean) {
        Collection trips = this.tripsByOcean.get((Object)ocean);
        return trips;
    }

    protected Map<String, String> getTripMap(Collection<Trip> trips) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Decorator decorator = this.getDecorator(Trip.class);
        Function toTopiaId = T3Functions.TO_TOPIA_ID;
        for (Trip filtredTrip : trips) {
            result.put(toTopiaId.apply((Object)filtredTrip), decorator.toString((Object)filtredTrip));
        }
        return result;
    }
}

