/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.T3TopiaRootContextFactory;
import fr.ird.t3.entities.user.JdbcConfiguration;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.web.actions.T3ActionSupport;
import fr.ird.t3.web.actions.admin.TripListModel;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImplementor;

public class T3Session
implements Closeable,
Serializable {
    private static final Log log = LogFactory.getLog(T3Session.class);
    private static final long serialVersionUID = 1L;
    private static final String SESSION_PARAMETER_T3_SESSION = "t3Session";
    public static final String PROPERTY_ACTION_CONTEXT = "actionContext";
    protected static final String PROPERTY_T3_USER = "t3User";
    protected static final String PROPERTY_ACTION_CONFIGURATION = "actionConfiguration";
    protected static final String PROPERTY_START_DATE = "startDate";
    protected static final String PROPERTY_USER_LOG_FILE = "userLogFile";
    protected static final String PROPERTY_TRIP_LIST_MODEL = "tripListModel";
    private static final String PROPERTY_ROOT_CONTEXT = "rootContext";
    protected static final String FILE_LOG_PATTERN = "%1$s-%2$td_%2$tm_%2$tY.log";
    protected transient Map<String, Object> store;

    public static T3Session getT3Session(ActionContext actionContext) {
        Map session = actionContext.getSession();
        T3Session t3Session = (T3Session)session.get(SESSION_PARAMETER_T3_SESSION);
        if (t3Session == null) {
            t3Session = new T3Session();
            session.put(SESSION_PARAMETER_T3_SESSION, t3Session);
        }
        return t3Session;
    }

    public static T3Session getT3Session(HttpSession session) {
        T3Session t3Session = (T3Session)session.getAttribute(SESSION_PARAMETER_T3_SESSION);
        if (t3Session == null) {
            t3Session = new T3Session();
            session.setAttribute(SESSION_PARAMETER_T3_SESSION, (Object)t3Session);
        }
        return t3Session;
    }

    public static void removeT3Session(ActionContext actionContext) {
        Map session = actionContext.getSession();
        session.remove(SESSION_PARAMETER_T3_SESSION);
    }

    public boolean isUserInSession() {
        boolean result = this.getT3User() != null;
        return result;
    }

    public boolean isT3DatabaseSelected() {
        boolean result = this.getT3DatabaseUrl() != null;
        return result;
    }

    public T3User getT3User() {
        return (T3User)this.get(PROPERTY_T3_USER, T3User.class);
    }

    public void setT3User(T3User t3User) {
        this.set(PROPERTY_T3_USER, (Object)t3User);
    }

    public String getT3DatabaseUrl() {
        TopiaContext rootContext = this.getRootContext();
        String result = null;
        if (rootContext != null) {
            result = (String)((TopiaContextImplementor)rootContext).getConfig().get("hibernate.connection.url");
        }
        return result;
    }

    public <C> C getActionConfiguration(Class<C> configurationClass) {
        String key = this.getActionConfigurationKey(configurationClass);
        return (C)this.get(key, configurationClass);
    }

    public <C> void setActionConfiguration(C actionConfiguration) {
        Preconditions.checkNotNull(actionConfiguration, (Object)"action configuration can not be null");
        String key = this.getActionConfigurationKey(actionConfiguration.getClass());
        this.set(key, actionConfiguration);
    }

    public <C> C removeActionConfiguration(Class<C> configurationClass) {
        String key = this.getActionConfigurationKey(configurationClass);
        Object remove = this.remove(key);
        return (C)remove;
    }

    public T3ActionContext<?> getActionContext() {
        return (T3ActionContext)this.get(PROPERTY_ACTION_CONTEXT, T3ActionContext.class);
    }

    public void setActionContext(T3ActionContext<?> actionContext) {
        this.set(PROPERTY_ACTION_CONTEXT, actionContext);
    }

    public void removeActionContext() {
        if (this.getActionContext() != null) {
            this.remove(PROPERTY_ACTION_CONTEXT);
        }
    }

    public Date getStartDate() {
        return (Date)this.get(PROPERTY_START_DATE, Date.class);
    }

    public void setStartDate(Date startDate) {
        this.set(PROPERTY_START_DATE, (Object)startDate);
    }

    public TripListModel getTripListModel() {
        return (TripListModel)this.get(PROPERTY_TRIP_LIST_MODEL, TripListModel.class);
    }

    public void setTripListModel(TripListModel tripListModel) {
        this.set(PROPERTY_TRIP_LIST_MODEL, (Object)tripListModel);
    }

    public void removeTripListModel() {
        this.remove(PROPERTY_TRIP_LIST_MODEL);
    }

    public TopiaContext getRootContext() {
        return (TopiaContext)this.get(PROPERTY_ROOT_CONTEXT, TopiaContext.class);
    }

    public File getUserLogFile() {
        File result = (File)this.get(PROPERTY_USER_LOG_FILE, File.class);
        if (result == null) {
            T3Configuration configuration = T3ActionSupport.getApplicationConfig();
            File userLogDirectory = configuration.getUserLogDirectory();
            String filename = String.format(FILE_LOG_PATTERN, this.getT3User().getLogin(), this.getStartDate());
            result = new File(userLogDirectory, filename);
            if (log.isInfoEnabled()) {
                log.info((Object)("User log file " + result.getAbsolutePath()));
            }
            this.set(PROPERTY_USER_LOG_FILE, (Object)result);
        }
        return result;
    }

    public Object remove(String key) {
        Object remove = this.getStore().remove(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove from user session data [" + key + "] = " + remove));
        }
        return remove;
    }

    public boolean contains(String key) {
        boolean result = this.getStore().containsKey(key);
        return result;
    }

    public void initDatabaseConfiguration(JdbcConfiguration jdbcConfiguration) throws TopiaNotFoundException {
        this.releaseDatabase();
        T3TopiaRootContextFactory factory = new T3TopiaRootContextFactory();
        TopiaContext rootContext = factory.newDb(jdbcConfiguration);
        this.set(PROPERTY_ROOT_CONTEXT, (Object)rootContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("User database initialized at " + jdbcConfiguration.getUrl()));
        }
    }

    public void releaseDatabase() {
        TopiaContext rootContext = this.getRootContext();
        if (rootContext != null) {
            this.remove(PROPERTY_ROOT_CONTEXT);
            T3EntityHelper.releaseRootContext((TopiaContext)rootContext);
        }
    }

    protected T3Session() {
    }

    protected Map<String, Object> getStore() {
        if (this.store == null) {
            this.store = Maps.newTreeMap();
        }
        return this.store;
    }

    protected <T> T get(String key, Class<T> type) {
        Object o = this.getStore().get(key);
        if (o != null && !type.isInstance(o)) {
            throw new ClassCastException("parameter " + key + " should be of type " + type.getName() + " but was " + o.getClass().getName());
        }
        return (T)o;
    }

    protected <C> String getActionConfigurationKey(Class<C> configurationClass) {
        return "actionConfiguration#" + configurationClass.getSimpleName();
    }

    protected void set(String key, Object value) {
        this.getStore().put(key, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set in user session data [" + key + "] = " + value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Close user session for [" + this.getT3User().getLogin() + "]"));
        }
        try {
            this.releaseDatabase();
        }
        finally {
            HashSet keys = Sets.newHashSet(this.getStore().keySet());
            for (String key : keys) {
                this.remove(key);
            }
        }
    }
}

