/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.input;

import com.opensymphony.xwork2.inject.Inject;
import fr.ird.t3.T3ConfigurationHelper;
import fr.ird.t3.actions.io.input.AnalyzeInputSourceConfiguration;
import fr.ird.t3.io.input.T3InputProvider;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;

public class ConfigureImportDataAction
extends AbstractConfigureAction<AnalyzeInputSourceConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureImportDataAction.class);
    public static final String RELOAD_ACTION = "reload";
    private List<T3InputProvider> inputProviders;
    protected File sourceToLoad;
    protected String sourceToLoadFileName;
    protected boolean useWells;
    private String treatmentDirectoryPath;
    private String loadedSource;
    private String inputProviderId;
    protected long maxSize;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    public String getMaxSize() {
        return StringUtil.convertMemory((long)this.maxSize);
    }

    public ConfigureImportDataAction() {
        super(AnalyzeInputSourceConfiguration.class);
    }

    public void prepare() throws Exception {
        this.inputProviders = !this.isConfigurationInSession() ? Arrays.asList(this.getT3InputService().getProviders()) : Arrays.asList(((AnalyzeInputSourceConfiguration)this.getConfiguration()).getInputProvider());
        if (this.getTreatmentDirectoryPath() == null) {
            ApplicationConfig config = this.getApplicationConfig();
            File workingDirectory = T3ConfigurationHelper.getTreatmentWorkingDirectory((ApplicationConfig)config);
            long l = System.nanoTime();
            File treatmentDirectory = new File(workingDirectory, "importData-" + l);
            FileUtil.createDirectoryIfNecessary((File)treatmentDirectory);
            if (log.isInfoEnabled()) {
                log.info((Object)("Create a new treatment directory path : " + treatmentDirectory));
            }
            this.setTreatmentDirectoryPath(treatmentDirectory.getAbsolutePath());
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Use existing treatment directory " + this.getTreatmentDirectoryPath()));
        }
    }

    public String doAddSource() throws Exception {
        File upload = this.getSourceToLoad();
        if (upload == null) {
            String message = this._("t3.error.required.file.to.upload", new Object[0]);
            this.addFieldError("sourceToLoad", message);
            log.error((Object)message);
            return "error";
        }
        File targetDirectory = this.getTreatmentDirectory();
        String filename = this.getSourceToLoadFileName();
        File target = new File(targetDirectory, filename);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will copy loaded file " + upload + " to treatment configuration directory " + target));
        }
        FileUtil.copy((File)upload, (File)target);
        this.setLoadedSource(filename);
        return "input";
    }

    public String doDeleteSource() throws Exception {
        boolean delete;
        File f;
        String filename = this.getLoadedSource();
        File targetDirectory = this.getTreatmentDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete loaded file " + filename + " from " + targetDirectory));
        }
        if ((f = new File(targetDirectory, filename)).exists() && !(delete = f.delete())) {
            throw new IOException("Could not delete file " + f + " on server.");
        }
        this.setLoadedSource(null);
        return "input";
    }

    public String doPrepareAnalyze() throws Exception {
        T3InputProvider inputProvider = this.getT3InputService().getProvider(this.getInputProviderId());
        File path = this.getTreatmentDirectory();
        String name = this.getLoadedSource();
        File inputFile = new File(path, name);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use input provider : " + inputProvider));
            log.info((Object)("Will use input file     : " + inputFile));
        }
        this.configuration = AnalyzeInputSourceConfiguration.newConfiguration((T3InputProvider)inputProvider, (File)inputFile, (boolean)this.useWells);
        this.prepareActionContext();
        return "success";
    }

    public File getSourceToLoad() {
        return this.sourceToLoad;
    }

    public String getSourceToLoadFileName() {
        return this.sourceToLoadFileName;
    }

    public void setSourceToLoad(File sourceToLoad) {
        this.sourceToLoad = sourceToLoad;
    }

    public void setSourceToLoadFileName(String sourceToLoadFileName) {
        this.sourceToLoadFileName = sourceToLoadFileName;
    }

    public boolean isUseWells() {
        return this.useWells;
    }

    public void setUseWells(boolean useWells) {
        this.useWells = useWells;
    }

    public String getInputProviderId() {
        return this.inputProviderId;
    }

    public void setInputProviderId(String inputProviderId) {
        this.inputProviderId = inputProviderId;
    }

    public String getLoadedSource() {
        return this.loadedSource;
    }

    public void setLoadedSource(String loadedSource) {
        this.loadedSource = loadedSource;
    }

    public String getTreatmentDirectoryPath() {
        return this.treatmentDirectoryPath;
    }

    public void setTreatmentDirectoryPath(String treatmentDirectoryPath) {
        this.treatmentDirectoryPath = treatmentDirectoryPath;
    }

    public final List<T3InputProvider> getInputProviders() {
        return this.inputProviders;
    }

    protected File getTreatmentDirectory() {
        String path = this.getTreatmentDirectoryPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }
}

