/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Multimap;
import fr.ird.t3.entities.data.Activity;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import java.util.List;

public class T3DatabaseDetailAction
extends T3BaseTransactionAction {
    private static final long serialVersionUID = -8408617621456216934L;
    @InjectFromDAO(entityType=Trip.class, method="findAllByOcean")
    protected transient Multimap<Ocean, Trip> tripsByOcean;
    protected List<Ocean> oceans;
    @InjectFromDAO(entityType=Trip.class, method="count")
    protected long nbTrips;
    @InjectFromDAO(entityType=Activity.class, method="count")
    protected long nbActivities;

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectFromDAO.class});
        this.oceans = this.sortToList((Collection)this.tripsByOcean.keySet());
        return "input";
    }

    public List<Ocean> getOceans() {
        return this.oceans;
    }

    public long getNbTrips() {
        return this.nbTrips;
    }

    public long getNbActivities() {
        return this.nbActivities;
    }

    public long getNbActivities(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        long result = 0L;
        for (Trip trip : trips) {
            result += (long)trip.sizeActivity();
        }
        return result;
    }

    public int getNbOceans() {
        return this.getOceans().size();
    }

    public int getNbTrips(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        return trips.size();
    }

    public String getFirstTripDate(Ocean ocean) {
        List trips = (List)this.getTrips(ocean);
        Trip trip = (Trip)trips.get(0);
        return this.formatDate(trip.getLandingDate());
    }

    public String getLastTripDate(Ocean ocean) {
        List trips = (List)this.getTrips(ocean);
        Trip trip = (Trip)trips.get(trips.size() - 1);
        return this.formatDate(trip.getLandingDate());
    }

    public Collection<String> getTripsWithNoDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithNoDataComputed((Collection)trips);
        Collection result = this.decorate(Trip.class, filtredTrips);
        return result;
    }

    public Collection<String> getTripsWithSomeDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithSomeDataComputed((Collection)trips);
        Collection result = this.decorate(Trip.class, filtredTrips);
        return result;
    }

    public Collection<String> getTripsWithAllDataComputed(Ocean ocean) {
        Collection trips = this.getTrips(ocean);
        Collection filtredTrips = TripDAO.getAllTripsWithAllDataComputed((Collection)trips);
        Collection result = this.decorate(Trip.class, filtredTrips);
        return result;
    }

    protected Collection<Trip> getTrips(Ocean ocean) {
        return this.tripsByOcean.get((Object)ocean);
    }
}

