/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.entities.user.T3UserImpl;
import fr.ird.t3.entities.user.UserDatabase;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import fr.ird.t3.web.actions.admin.AbstractUserDatabaseAction;
import fr.ird.t3.web.actions.admin.EditActionEnum;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public abstract class AbstractUserDatabaseAction<T extends UserDatabase>
extends T3BaseTransactionAction
implements Preparable {
    private static final Log log = LogFactory.getLog(AbstractUserDatabaseAction.class);
    private static final long serialVersionUID = -2894789101651139566L;
    public static final String T3_DATABASE = "t3Database";
    public static final String OUPUT_DATABASE = "outputDatabase";
    protected T databaseConfiguration;
    protected T3User user;
    protected String databaseEditAction;
    protected String userEditAction;

    protected abstract T getDatabase(String var1) throws TopiaException;

    public abstract T getDatabaseConfiguration();

    protected abstract Collection<T> getDatabases(T3User var1);

    public abstract String getDatabaseType();

    protected abstract void create(String var1, T var2) throws Exception;

    protected abstract void update(T var1) throws Exception;

    protected abstract void delete(String var1, T var2) throws Exception;

    public void prepare() throws Exception {
        String id = this.getDatabaseConfiguration().getTopiaId();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            this.databaseConfiguration = this.getDatabase(id);
        }
    }

    public String doCreate() throws Exception {
        UserDatabase configuration = this.getDatabaseConfiguration();
        if (log.isInfoEnabled()) {
            log.info((Object)("will create database configuration  " + configuration.getDescription()));
        }
        String userId = this.getUser().getTopiaId();
        this.create(userId, configuration);
        return "success";
    }

    public String doUpdate() throws Exception {
        UserDatabase configuration = this.getDatabaseConfiguration();
        if (log.isInfoEnabled()) {
            log.info((Object)("will update user  " + configuration.getDescription()));
        }
        this.update(configuration);
        return "success";
    }

    public String doDelete() throws Exception {
        UserDatabase configuration = this.getDatabaseConfiguration();
        if (log.isInfoEnabled()) {
            log.info((Object)("will update user  " + configuration.getDescription()));
        }
        String userId = this.getUser().getTopiaId();
        this.delete(userId, configuration);
        return "success";
    }

    public void validate() {
        EditActionEnum action = this.getEditActionEnum();
        log.info((Object)("Edit action : " + action));
        if (action == null) {
            return;
        }
        UserDatabase configuration = this.getDatabaseConfiguration();
        String userId = this.getUser().getTopiaId();
        String description = configuration.getDescription();
        String login = configuration.getLogin();
        String url = configuration.getUrl();
        String id = configuration.getTopiaId();
        boolean noError = true;
        switch (1.$SwitchMap$fr$ird$t3$web$actions$admin$EditActionEnum[action.ordinal()]) {
            case 1: {
                T3User t3User;
                if (StringUtils.isEmpty((CharSequence)description)) {
                    this.addFieldError("databaseConfiguration.description", this._("t3.error.required.description", new Object[0]));
                    noError = false;
                }
                if (StringUtils.isEmpty((CharSequence)url)) {
                    this.addFieldError("databaseConfiguration.url", this._("t3.error.required.url", new Object[0]));
                    noError = false;
                }
                if (StringUtils.isEmpty((CharSequence)login)) {
                    this.addFieldError("databaseConfiguration.login", this._("t3.error.required.login", new Object[0]));
                    noError = false;
                }
                if (!noError) break;
                try {
                    t3User = this.getUserService().getUserById(userId);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not obtain user " + userId, e);
                }
                Collection databases = this.getDatabases(t3User);
                UserDatabase existingDatabase = null;
                if (CollectionUtils.isNotEmpty((Collection)databases)) {
                    for (UserDatabase database : databases) {
                        if (!description.equals(database.getDescription())) continue;
                        existingDatabase = database;
                        break;
                    }
                }
                if (existingDatabase == null) break;
                this.addFieldError("databaseConfiguration.description", this._("t3.error.configuration.description.already.used", new Object[0]));
                break;
            }
            case 2: {
                T3User t3User;
                if (StringUtils.isEmpty((CharSequence)description)) {
                    this.addFieldError("databaseConfiguration.description", this._("t3.error.required.description", new Object[0]));
                    noError = false;
                }
                if (StringUtils.isEmpty((CharSequence)url)) {
                    this.addFieldError("databaseConfiguration.url", this._("t3.error.required.url", new Object[0]));
                    noError = false;
                }
                if (StringUtils.isEmpty((CharSequence)login)) {
                    this.addFieldError("databaseConfiguration.login", this._("t3.error.required.login", new Object[0]));
                    noError = false;
                }
                if (!noError) break;
                try {
                    t3User = this.getUserService().getUserById(userId);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not obtain user " + userId, e);
                }
                Collection databases = this.getDatabases(t3User);
                UserDatabase existingDatabase = null;
                if (CollectionUtils.isNotEmpty((Collection)databases)) {
                    for (UserDatabase database : databases) {
                        if (!description.equals(database.getDescription()) || id.equals(database.getTopiaId())) continue;
                        existingDatabase = database;
                        break;
                    }
                }
                if (existingDatabase == null) break;
                this.addFieldError("databaseConfiguration.description", this._("t3.error.configuration.description.already.used", new Object[0]));
                break;
            }
        }
    }

    public String getUserEditAction() {
        return this.userEditAction;
    }

    public void setUserEditAction(String userEditAction) {
        this.userEditAction = userEditAction;
    }

    public String getDatabaseEditAction() {
        return this.databaseEditAction;
    }

    public void setDatabaseEditAction(String databaseEditAction) {
        this.databaseEditAction = databaseEditAction;
    }

    public T3User getUser() {
        if (this.user == null) {
            this.user = new T3UserImpl();
        }
        return this.user;
    }

    protected EditActionEnum getEditActionEnum() {
        if (this.databaseEditAction == null) {
            return null;
        }
        return EditActionEnum.valueOf((String)this.databaseEditAction.toUpperCase());
    }
}

