/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ird.t3.actions.data.StratumMinimumSampleCount;
import fr.ird.t3.actions.data.level3.Level3Configuration;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigureLevel3Step2Action
extends AbstractConfigureAction<Level3Configuration>
implements ParameterAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureLevel3Step2Action.class);
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    protected Level3Configuration configuration;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> sampleFleets;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> sampleFlags;
    @InjectDecoratedBeans(beanType=Species.class, filterById=true, pathIds="speciesIds")
    protected Map<String, String> species;
    protected final Map<String, String> timeSteps = this.createTimeSteps();
    protected boolean missingDatas;
    public static final Pattern BO_STRATUM_MINIMUM_COUNT_PATTERN = Pattern.compile("BO:(.*)?");
    public static final Pattern BL_STRATUM_MINIMUM_COUNT_PATTERN = Pattern.compile("BL:(.*)?");

    public ConfigureLevel3Step2Action() {
        super(Level3Configuration.class);
    }

    public void prepare() throws Exception {
        Level3Configuration conf = (Level3Configuration)this.getConfiguration();
        if (log.isInfoEnabled()) {
            log.info((Object)("Prepare with configuration " + conf));
        }
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        this.missingDatas = false;
        ArrayList sampleFleetCountries = Lists.newArrayList();
        ArrayList sampleFlagCountries = Lists.newArrayList();
        String oceanId = conf.getOceanId();
        sampleFleetCountries.addAll(this.countryDAO.findAllFleetUsedInSample(oceanId));
        sampleFlagCountries.addAll(this.countryDAO.findAllFlagUsedInSample(oceanId));
        conf.setSampleFlags((List)sampleFlagCountries);
        conf.setSampleFleets((List)sampleFleetCountries);
        if (CollectionUtils.isEmpty((Collection)sampleFleetCountries)) {
            this.addFieldError("configuration.sampleFleetIds", this._("t3.error.no.sample.fleet.found", new Object[0]));
            this.missingDatas = true;
        }
        if (CollectionUtils.isEmpty((Collection)sampleFlagCountries)) {
            this.addFieldError("configuration.sampleFlagIds", this._("t3.error.no.sample.flag.found", new Object[0]));
            this.missingDatas = true;
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
        for (Species aSpecies : conf.getSpecies()) {
            String specieId = aSpecies.getTopiaId();
            StratumMinimumSampleCount sampleCount = this.getStratumMinimumSampleCount(specieId);
            if (sampleCount != null) continue;
            sampleCount = new StratumMinimumSampleCount();
            Integer thresholdNumberLevel3FreeSchoolType = aSpecies.getThresholdNumberLevel3FreeSchoolType();
            Integer thresholdNumberLevel3ObjectSchoolType = aSpecies.getThresholdNumberLevel3ObjectSchoolType();
            sampleCount.setMinimumCountForFreeSchool(thresholdNumberLevel3FreeSchoolType);
            sampleCount.setMinimumCountForObjectSchool(thresholdNumberLevel3ObjectSchoolType);
            this.getStratumMinimumSampleCount().put(specieId, sampleCount);
        }
        float stratumWeightRatio = conf.getStratumWeightRatio();
        if (stratumWeightRatio == 0.0f) {
            stratumWeightRatio = ConfigureLevel3Step2Action.getApplicationConfig().getStratumWeightRatio().floatValue();
            conf.setStratumWeightRatio(stratumWeightRatio);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected sample fleet countries  : " + conf.getSampleFleetIds()));
            log.info((Object)("Selected sample flag  countries  : " + conf.getSampleFlagIds()));
            log.info((Object)("Selected weight ratio            : " + conf.getStratumWeightRatio()));
            for (String specieId : conf.getSpeciesIds()) {
                String specieLabel = (String)this.getSpecies().get(specieId);
                log.info((Object)("[" + specieLabel + "] min sample count BL     : " + this.getStratumMinimumSampleCountFreeSchoolType(specieId)));
                log.info((Object)("[" + specieLabel + "] min sample count BO     : " + this.getStratumMinimumSampleCountObjectSchoolType(specieId)));
            }
        }
    }

    public Map<String, StratumMinimumSampleCount> getStratumMinimumSampleCount() {
        Map stratumMinimumSampleCount = ((Level3Configuration)this.getConfiguration()).getStratumMinimumSampleCount();
        if (stratumMinimumSampleCount == null) {
            stratumMinimumSampleCount = Maps.newTreeMap();
            ((Level3Configuration)this.getConfiguration()).setStratumMinimumSampleCount(stratumMinimumSampleCount);
        }
        return stratumMinimumSampleCount;
    }

    public StratumMinimumSampleCount getStratumMinimumSampleCount(String specie) {
        return (StratumMinimumSampleCount)this.getStratumMinimumSampleCount().get(specie);
    }

    public void validate() {
        Level3Configuration conf = (Level3Configuration)this.getConfiguration();
        if (CollectionUtils.isEmpty((Collection)conf.getSampleFlagIds())) {
            this.addFieldError("configuration.sampleFlagIds", this._("t3.error.no.sample.flag.selected", new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)conf.getSampleFleetIds())) {
            this.addFieldError("configuration.sampleFleetIds", this._("t3.error.no.sample.fleet.selected", new Object[0]));
        }
    }

    public String execute() throws Exception {
        Level3Configuration config = (Level3Configuration)this.getConfiguration();
        config.setValidStep2(true);
        return "success";
    }

    public Map<String, String> getSampleFleets() {
        return this.sampleFleets;
    }

    public Map<String, String> getSampleFlags() {
        return this.sampleFlags;
    }

    public Map<String, String> getTimeSteps() {
        return this.timeSteps;
    }

    public Integer getStratumMinimumSampleCountObjectSchoolType(String specieId) {
        StratumMinimumSampleCount sampleCount = this.getStratumMinimumSampleCount(specieId);
        return sampleCount.getMinimumCountForObjectSchool();
    }

    public void setStratumMinimumSampleCountObjectSchoolType(String specieId, Integer stratumMinimumSampleCountObjectSchoolType) {
        StratumMinimumSampleCount sampleCount = this.getStratumMinimumSampleCount(specieId);
        sampleCount.setMinimumCountForObjectSchool(stratumMinimumSampleCountObjectSchoolType);
    }

    public Integer getStratumMinimumSampleCountFreeSchoolType(String specieId) {
        StratumMinimumSampleCount sampleCount = this.getStratumMinimumSampleCount(specieId);
        return sampleCount.getMinimumCountForFreeSchool();
    }

    public void setStratumMinimumSampleCountFreeSchoolType(String specieId, Integer stratumMinimumSampleCountFreeSchoolType) {
        StratumMinimumSampleCount sampleCount = this.getStratumMinimumSampleCount(specieId);
        sampleCount.setMinimumCountForFreeSchool(stratumMinimumSampleCountFreeSchoolType);
    }

    public boolean isMissingDatas() {
        return this.missingDatas;
    }

    public void setParameters(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> e : parameters.entrySet()) {
            Integer realValue;
            StratumMinimumSampleCount sampleCount;
            String specieId;
            String name = e.getKey();
            String[] values = e.getValue();
            Matcher matcher = BO_STRATUM_MINIMUM_COUNT_PATTERN.matcher(name);
            if (matcher.matches()) {
                specieId = matcher.group(1);
                sampleCount = this.getStratumMinimumSampleCount(specieId);
                realValue = null;
                if (values.length > 0) {
                    try {
                        realValue = Integer.valueOf(values[0]);
                    }
                    catch (NumberFormatException e1) {
                        this.addFieldError(name, this._("t3.error.invalid.integer", new Object[0]));
                    }
                }
                sampleCount.setMinimumCountForObjectSchool(realValue);
                continue;
            }
            matcher = BL_STRATUM_MINIMUM_COUNT_PATTERN.matcher(name);
            if (!matcher.matches()) continue;
            specieId = matcher.group(1);
            sampleCount = this.getStratumMinimumSampleCount(specieId);
            realValue = null;
            if (values.length > 0) {
                try {
                    realValue = Integer.valueOf(values[0]);
                }
                catch (NumberFormatException e1) {
                    this.addFieldError(name, this._("t3.error.invalid.integer", new Object[0]));
                }
            }
            sampleCount.setMinimumCountForFreeSchool(realValue);
        }
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }
}

