<%--
  #%L
  T3 :: Web
  
  $Id: tripForm.jsp 624 2011-10-25 11:48:18Z chemit $
  $HeadURL: https://svn.mpl.ird.fr/osiris/t3/tags/t3-1.0/t3-web/src/main/webapp/WEB-INF/jsp/admin/tripForm.jsp $
  %%
  Copyright (C) 2010 - 2011 IRD, Codelutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<s:set var="userIsAdmin" value="%{#session.t3Session.t3User.admin}"/>

<s:if test="tripEditAction == 'delete'">
  <s:set name="title"><s:text name="t3.label.admin.trip.delete.trips"/></s:set>
</s:if>
<s:else>
  <s:set name="title"><s:text name="t3.label.admin.trip.detail"/></s:set>
</s:else>

<title><s:property value="#title"/></title>

<h2><s:property value="#title"/></h2>

<s:if test="tripEditAction == 'detail'">

  <s:form method="post" namespace="/trip">
    <fieldset>
      <legend>
        <s:text name="t3.common.trip.general"/>
      </legend>
      <s:hidden key="userEditAction" label=""/>
      <s:label key="trip.vessel.libelle"
               label="%{getText('t3.common.vessel')}"/>
      <s:label key="trip.landingDate"
               label="%{getText('t3.common.landingDate')}"/>
    </fieldset>
    <br/>

    <s:submit action="tripList" key="t3.label.admin.backToTripList"
              align="right"/>
  </s:form>
</s:if>

<s:elseif test="tripEditAction == 'delete'">

  <%--Delete trips --%>

  <s:form method="post" namespace="/trip">
    <fieldset>
      <legend>
        <s:text name="t3.common.trips.to.treat"/>
      </legend>
      <ul>
        <s:iterator value="tripsToDelete" status="status">
          <s:hidden name="tripIds" value="%{key}"/>
          <li>
            <s:property value="value"/>
          </li>
        </s:iterator>
      </ul>
      <s:hidden name="tripEditAction" label=""/>
    </fieldset>
    <br/>
    <s:submit action="tripForm!doDelete" key="t3.action.deleteTrips" align="right"/>
    <s:submit action="tripForm!doDeleteComputedData" key="t3.action.deleteComputedData" align="right"/>
    <s:submit action="tripList" key="t3.label.admin.backToTripList"
              align="right"/>
  </s:form>
</s:elseif>



