/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.util;

import fr.inria.peerunit.util.LogFormat;
import fr.inria.peerunit.util.TesterUtil;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeerUnitLogger {
    private static Logger LOG;

    public PeerUnitLogger(String name) {
        LOG = Logger.getLogger(name);
    }

    public synchronized void createLogger(String pattern) {
        LogFormat format = new LogFormat();
        Level level = TesterUtil.instance.getLogLevel();
        FileHandler handler = null;
        try {
            handler = new FileHandler(pattern, true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        handler.setFormatter(format);
        LOG.addHandler(handler);
        LOG.setLevel(level);
        LOG.log(level, "Logfile location: " + pattern);
    }

    public synchronized void log(Level level, String msg) {
        LOG.log(level, msg);
    }

    public synchronized void logStackTrace(Exception e) {
        StackTraceElement[] elements = e.getStackTrace();
        LOG.log(Level.SEVERE, e.toString());
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            LOG.log(Level.SEVERE, "at " + elements[i].toString());
        }
        LOG.log(Level.SEVERE, "Caused by: " + e.getCause());
    }
}

