/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.test.oracle;

import fr.inria.peerunit.base.ResultSet;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.test.oracle.Verdicts;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class GlobalVerdict {
    private Verdicts globalVerdict = null;
    private int passVerdicts = 0;
    private int incVerdicts = 0;
    private int failVerdicts = 0;
    private int index;
    private Map<MethodDescription, ResultSet> results;

    public GlobalVerdict(int i) {
        this.index = i;
        this.results = Collections.synchronizedMap(new TreeMap());
    }

    public void addLocalVerdict(Verdicts localVerdict) {
        switch (localVerdict) {
            case FAIL: {
                ++this.failVerdicts;
                break;
            }
            case PASS: {
                ++this.passVerdicts;
                break;
            }
            case INCONCLUSIVE: {
                ++this.incVerdicts;
                break;
            }
            default: {
                System.err.println("Unknown verdict");
            }
        }
    }

    public Verdicts getGlobalVerdict() {
        this.calculateVerdict();
        return this.globalVerdict;
    }

    public int getJudged() {
        return this.passVerdicts + this.incVerdicts + this.failVerdicts;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("------------------------------\n");
        result.append("Test Case Verdict: \n");
        for (ResultSet each : this.results.values()) {
            result.append(each).append("\n");
        }
        result.append("------------------------------\n");
        return result.toString();
    }

    private void calculateVerdict() {
        this.globalVerdict = this.failVerdicts > 0 ? Verdicts.FAIL : ((double)this.incVerdicts / (double)(this.passVerdicts + this.incVerdicts) * 100.0 <= (double)this.index ? Verdicts.PASS : Verdicts.INCONCLUSIVE);
    }

    public void putResult(MethodDescription md, ResultSet rs) {
        this.results.put(md, rs);
    }

    public ResultSet getResultFor(MethodDescription md) {
        return this.results.get(md);
    }

    public boolean containsMethod(MethodDescription md) {
        return this.results.containsKey(md);
    }
}

