/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.base;

import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.util.LogFormat;
import fr.inria.peerunit.util.TesterUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTester
implements Tester {
    private static final Logger LOG = Logger.getLogger(AbstractTester.class.getName());
    protected int id;
    protected transient GlobalVariables globals;
    protected transient TesterUtil defaults = TesterUtil.instance;

    public AbstractTester() {
    }

    public AbstractTester(GlobalVariables gv) {
        this.globals = gv;
    }

    @Override
    public int getId() {
        LOG.entering("AbstractTester", "getId()");
        return this.id;
    }

    public void setId(int i) {
        LOG.entering("AbstractTester", "setId(int)");
        this.id = i;
    }

    public int getPeerName() throws RemoteException {
        return this.getId();
    }

    public String toString() {
        return String.format("Tester: %d", this.id);
    }

    @Override
    public void put(Integer key, Object object) throws RemoteException {
        this.globalTable().put(key, object);
    }

    @Override
    public Map<Integer, Object> getCollection() throws RemoteException {
        return this.globalTable().getCollection();
    }

    @Override
    public Object get(Integer key) throws RemoteException {
        return this.globalTable().get(key);
    }

    @Override
    public boolean containsKey(Integer key) throws RemoteException {
        return this.globalTable().containsKey(key);
    }

    @Override
    public void clear() throws RemoteException {
        this.globalTable().clearCollection();
    }

    protected final GlobalVariables globalTable() {
        return this.globals;
    }

    protected void initializeLogger() {
        try {
            Level level = this.defaults.getLogLevel();
            FileHandler handler = new FileHandler(String.format("Tester%d.log", this.id));
            handler.setFormatter(new LogFormat());
            handler.setLevel(level);
            Logger myLogger = Logger.getLogger("fr.inria");
            myLogger.setUseParentHandlers(false);
            myLogger.addHandler(handler);
            myLogger.setLevel(level);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

