/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.rmi.tester.DistributedTesterImpl;
import fr.inria.peerunit.rmi.tester.TesterImpl;
import fr.inria.peerunit.util.LogFormat;
import fr.inria.peerunit.util.TesterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner {
    private Class<?> testcase;
    private TesterUtil defaults;
    private Registry registry;
    private static final Logger LOG = Logger.getLogger(TestRunner.class.getName());

    public TestRunner(Class<?> klass, TesterUtil tu) {
        this.defaults = tu;
        this.testcase = klass;
        Bootstrapper boot = null;
        this.registry = null;
        int times = 0;
        boolean centralized = true;
        this.initializeLogger();
        try {
            this.registry = LocateRegistry.getRegistry(this.defaults.getRegistryPort());
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        while (times < 5 && boot == null) {
            try {
                boot = (Bootstrapper)this.registry.lookup("Bootstrapper");
                centralized = false;
            }
            catch (NotBoundException ex) {
                try {
                    boot = (Bootstrapper)this.registry.lookup("Coordinator");
                }
                catch (Exception e) {}
            }
            catch (AccessException ex) {
            }
            catch (RemoteException ex) {
                // empty catch block
            }
            ++times;
            if (boot != null) continue;
            try {
                Thread.sleep(300 * times);
            }
            catch (InterruptedException e) {}
        }
        if (boot == null) {
            LOG.severe("Unable to bind");
            System.exit(1);
        }
        try {
            GlobalVariables globals = (GlobalVariables)this.registry.lookup("Globals");
            if (centralized) {
                LOG.fine("Coordinator found, using the centralized architecture.");
                TesterImpl tester = new TesterImpl(boot, globals, this.defaults);
                UnicastRemoteObject.exportObject(tester);
                tester.setCoordinator((Coordinator)((Object)boot));
                tester.registerTestCase(this.testcase);
                tester.start();
                tester.run();
                System.exit(0);
            } else {
                LOG.fine("Bootstrapper found, using the distributed architecture.");
                DistributedTesterImpl tester = new DistributedTesterImpl(this.testcase, boot, globals, this.defaults);
                UnicastRemoteObject.exportObject(tester);
                tester.register();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void initializeLogger() {
        try {
            Level level = this.defaults.getLogLevel();
            LogFormat formatter = new LogFormat();
            Logger.getLogger("fr.inria").setLevel(level);
            Logger.getLogger("").getHandlers()[0].setLevel(level);
            Logger.getLogger("").getHandlers()[0].setFormatter(formatter);
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java TestRunner TestCaseClass [Properties File]");
        } else {
            String name = args[0];
            try {
                TesterUtil defaults;
                Class<?> klass = Class.forName(name);
                if (args.length > 1) {
                    String filename = args[1];
                    FileInputStream fs = new FileInputStream(filename);
                    defaults = new TesterUtil(fs);
                } else if (new File("peerunit.properties").exists()) {
                    String filename = "peerunit.properties";
                    FileInputStream fs = new FileInputStream(filename);
                    defaults = new TesterUtil(fs);
                } else {
                    defaults = TesterUtil.instance;
                }
                new TestRunner(klass, defaults);
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: Unable to open properties file");
                System.exit(1);
            }
            catch (ClassCastException e) {
                System.out.println("Error: Class " + name + " does not implement TestCase interface.");
            }
            catch (ClassNotFoundException e) {
                System.out.println("Error: Class " + name + " not found.");
            }
        }
    }
}

