/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharRangeMatcher
extends AbstractMatcher {
    public final char cLow;
    public final char cHigh;

    public CharRangeMatcher(char cLow, char cHigh) {
        super(StringUtils.escape(cLow) + ".." + StringUtils.escape(cHigh));
        Preconditions.checkArgument(cLow < cHigh);
        this.cLow = cLow;
        this.cHigh = cHigh;
    }

    public boolean match(MatcherContext context) {
        char c = context.getCurrentChar();
        if (c < this.cLow || c > this.cHigh) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkArgNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

