/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.dto;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;

public class DTOHelper {
    static Log log = LogFactory.getLog(DTOHelper.class);

    public static <E extends BusinessEntity> E toDto(E w) {
        BusinessEntity result = null;
        if (w != null) {
            Class<?> clazz = w.getClass();
            String dtoClassName = clazz.getName().replace("Impl", "DTO").replace("CopyOnWrite", "DTO");
            try {
                String wikittyId = w.getWikittyId();
                result = (BusinessEntity)ObjectUtil.newInstance((String)(dtoClassName + "(" + wikittyId + ")"));
                result.copyFrom(w);
            }
            catch (Exception eee) {
                log.error((Object)"Could not transform Wikitty to DTO", (Throwable)eee);
            }
        }
        return (E)result;
    }

    public static <E extends BusinessEntity> E fromDto(WikittyClient client, Class<E> clazz, E dto) {
        BusinessEntity result = client.restore(clazz, dto.getWikittyId());
        if (result == null) {
            try {
                String wikittyId = dto.getWikittyId();
                WikittyImpl wikitty = new WikittyImpl(wikittyId);
                result = WikittyUtil.newInstance(clazz, (Wikitty)wikitty);
            }
            catch (Exception eee) {
                log.error((Object)"Could not transform DTO to Wikitty", (Throwable)eee);
            }
        }
        if (result != null) {
            result.copyFrom(dto);
        }
        return (E)result;
    }
}

