/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public abstract class DualFloatFunction
extends ValueSource {
    protected final ValueSource a;
    protected final ValueSource b;

    public DualFloatFunction(ValueSource a, ValueSource b) {
        this.a = a;
        this.b = b;
    }

    protected abstract String name();

    protected abstract float func(int var1, DocValues var2, DocValues var3);

    public String description() {
        return this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues aVals = this.a.getValues(context, reader);
        final DocValues bVals = this.b.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return DualFloatFunction.this.func(doc, aVals, bVals);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return DualFloatFunction.this.name() + '(' + aVals.toString(doc) + ',' + bVals.toString(doc) + ')';
            }
        };
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.a.createWeight(context, searcher);
        this.b.createWeight(context, searcher);
    }

    public int hashCode() {
        int h = this.a.hashCode();
        h ^= h << 13 | h >>> 20;
        h += this.b.hashCode();
        h ^= h << 23 | h >>> 10;
        return h += this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DualFloatFunction other = (DualFloatFunction)o;
        return this.a.equals(other.a) && this.b.equals(other.b);
    }
}

