/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class KeywordMarkerFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private CharArraySet protectedWords;
    private boolean ignoreCase;

    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (wordFiles != null) {
            try {
                this.protectedWords = this.getWordSet(loader, wordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public TokenStream create(TokenStream input) {
        return this.protectedWords == null ? input : new KeywordMarkerFilter(input, this.protectedWords);
    }
}

