/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.collation.CollationKeyFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class CollationKeyFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Collator collator;

    public void inform(ResourceLoader loader) {
        String custom = (String)this.args.get("custom");
        String language = (String)this.args.get("language");
        String country = (String)this.args.get("country");
        String variant = (String)this.args.get("variant");
        String strength = (String)this.args.get("strength");
        String decomposition = (String)this.args.get("decomposition");
        if (custom == null && language == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or language is required.");
        }
        if (custom != null && (language != null || country != null || variant != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both language and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        this.collator = language != null ? this.createFromLocale(language, country, variant) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                this.collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                this.collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                this.collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("identical")) {
                this.collator.setStrength(3);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                this.collator.setDecomposition(0);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                this.collator.setDecomposition(1);
            } else if (decomposition.equalsIgnoreCase("full")) {
                this.collator.setDecomposition(2);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
    }

    public TokenStream create(TokenStream input) {
        return new CollationKeyFilter(input, this.collator);
    }

    private Collator createFromLocale(String language, String country, String variant) {
        if (language != null && country == null && variant != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "To specify variant, country is required");
        }
        Locale locale = language != null && country != null && variant != null ? new Locale(language, country, variant) : (language != null && country != null ? new Locale(language, country) : new Locale(language));
        return Collator.getInstance(locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collator createFromRules(String fileName, ResourceLoader loader) {
        RuleBasedCollator ruleBasedCollator;
        InputStream input = null;
        try {
            try {
                input = loader.openResource(fileName);
                String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
                ruleBasedCollator = new RuleBasedCollator(rules);
                Object var7_8 = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IOUtils.closeQuietly((InputStream)input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return ruleBasedCollator;
    }
}

