/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedByte
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected byte value_;

    public SynchronizedByte(byte initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedByte(byte initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public byte add(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ + amount);
            Object var4_4 = null;
            return by;
        }
    }

    public byte and(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ & b);
            Object var4_4 = null;
            return by;
        }
    }

    public boolean commit(byte assumedValue, byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            Object var5_6 = null;
            return bl2;
        }
    }

    public int compareTo(byte other) {
        byte val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedByte other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedByte)other);
    }

    public byte complement() {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(~this.value_);
            Object var3_3 = null;
            return by;
        }
    }

    public byte decrement() {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ - 1);
            Object var3_3 = null;
            return by;
        }
    }

    public byte divide(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ / factor);
            Object var4_4 = null;
            return by;
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedByte) {
            return this.get() == ((SynchronizedByte)other).get();
        }
        return false;
    }

    public final byte get() {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_;
            Object var3_3 = null;
            return by;
        }
    }

    public int hashCode() {
        return this.get();
    }

    public byte increment() {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ + 1);
            Object var3_3 = null;
            return by;
        }
    }

    public synchronized byte multiply(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ * factor);
            Object var4_4 = null;
            return by;
        }
    }

    public byte negate() {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(-this.value_);
            Object var3_3 = null;
            return by;
        }
    }

    public byte or(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ | b);
            Object var4_4 = null;
            return by;
        }
    }

    public byte set(byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            byte old = this.value_;
            this.value_ = newValue;
            byte by = old;
            Object var4_5 = null;
            return by;
        }
    }

    public byte subtract(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ - amount);
            Object var4_4 = null;
            return by;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte swap(SynchronizedByte other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedByte fst = this;
        SynchronizedByte snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    public String toString() {
        return Byte.toString(this.get());
    }

    public byte xor(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            byte by = this.value_ = (byte)(this.value_ ^ b);
            Object var4_4 = null;
            return by;
        }
    }
}

