/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompSession.java 188 2011-06-16 08:21:53Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompSession.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nuiton.wikitty.entities.WikittyUser;

/**
 *
 * The user session. Only this object is stored into the user session.
 *
 * User: couteau
 * Date: 30 nov. 2010
 */
public class RefcompSession {

    /** The StorageService corresponding to the logged in user **/
    StorageService service;

    /** The logged in user **/
    WikittyUser user;
    
    /** If the logged in user is an agent **/
    Boolean agent;
    
    /** If the logged in user is an admin **/
    Boolean admin;

    public static final String NAME = "refcompSession";

    public RefcompSession(){
        service = null;
    }

    /**
     * Get the StorageService corresponding to the logged in user
     *
     * @return the service corresponding to the logged-in user.
     */
    public StorageService getService() {
        return service;
    }

    /**
     * Set the service corresponding to the logged in user
     *
     * @param service the service corresponding to the logged-in user.
     */
    public void setService(StorageService service) {
        this.service = service;
    }

    /**
     * Set the logged in user
     * @param user the logged in user
     */
    public void setUser(WikittyUser user) {
        this.user = user;
    }

    /**
     * Get the logged in user
     * @return the logged in user, null if the user is not logged in
     */
    public WikittyUser getUser() {
        return user;
    }

    /**
     * Clear the logged-in user (used when logging out user)
     */
    public void clearUser() {
        user = null;
    }

    public Boolean getAdmin() {
        return admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public Boolean getAgent() {
        return agent;
    }

    public void setAgent(Boolean agent) {
        this.agent = agent;
    }

    public static RefcompSession getSession(HttpServletRequest request) {
        HttpSession session = request.getSession();

        // If the session does not contain the session object, create a new RefcompSession
        if (session.getAttribute(NAME) == null) {
            session.setAttribute(NAME, new RefcompSession());
        }

        // Return the RefcompSession
        return (RefcompSession) session.getAttribute(NAME);
    }
}
