/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompSession.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompSession.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyUser;

/**
 *
 * The user session. Only this object is stored into the user session.
 *
 * User: couteau
 * Date: 30 nov. 2010
 */
public class RefcompSession {

    /** The StorageService corresponding to the logged in user **/
    StorageService service;

    /** The logged in user **/
    WikittyUser user;

    public RefcompSession(){
        service = null;
    }

    /**
     * Get the StorageService corresponding to the logged in user
     *
     * @return the service corresponding to the logged-in user.
     */
    public StorageService getService() {
        return service;
    }

    /**
     * Set the service corresponding to the logged in user
     *
     * @param service the service corresponding to the logged-in user.
     */
    public void setService(StorageService service) {
        this.service = service;
    }

    /**
     * Set the logged in user
     * @param user the logged in user
     */
    public void setUser(WikittyUser user) {
        this.user = user;
    }

    /**
     * Get the logged in user
     * @return the logged in user, null if the user is not logged in
     */
    public WikittyUser getUser() {
        return user;
    }

    /**
     * Clear the logged-in user (used when logging out user)
     */
    public void clearUser() {
        user = null;
    }
}
