/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;

public class UnitDTO implements Unit {

@WikittyField(fqn="Unit.name")    protected String name;

@WikittyField(fqn="Unit.address")    protected String address;

@WikittyField(fqn="Unit.fullName")    protected String fullName;

@WikittyField(fqn="Unit.unitDeptLink")    protected Set<String> unitDeptLink = new LinkedHashSet<String>();

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public String getName() {
        return name;
}

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    @Override
    public String getAddress() {
        return address;
}

    @Override
    public void setAddress(String address) {
        this.address=address;
        modificationCount++;
}

    @Override
    public String getFullName() {
        return fullName;
}

    @Override
    public void setFullName(String fullName) {
        this.fullName=fullName;
        modificationCount++;
}

    @Override
    public Set<String> getUnitDeptLink() {
        return unitDeptLink;
}

    @Override
    public void setUnitDeptLink(Set<String> unitDeptLink) {
        if (unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.unitDeptLink=new LinkedHashSet<String>(unitDeptLink);
        }
        modificationCount++;
}

    @Override
    public void addAllUnitDeptLink(Collection<String> unitDeptLink) {
        if (this.unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        }
        this.unitDeptLink.addAll(unitDeptLink);
        modificationCount++;
}

    @Override
    public void addUnitDeptLink(String... element) {
        if (this.unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.unitDeptLink.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeUnitDeptLink(String... element) {
        if (this.unitDeptLink != null) {
            for (String v : element) {
                unitDeptLink.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearUnitDeptLink() {
        if (this.unitDeptLink != null) {
            unitDeptLink.clear();
            modificationCount++;
        }
}

    @Override
    public Set<UnitDeptLink> getUnitDeptLink(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (UnitDeptLink e : unitDeptLink) {
            tmp.add(e.getWikittyId());
        }
        setUnitDeptLink(tmp);
}

    @Override
    public void addAllUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (UnitDeptLink e : unitDeptLink) {
            tmp.add(e.getWikittyId());
        }
        addAllUnitDeptLink(tmp);
}

    @Override
    public void addUnitDeptLink(UnitDeptLink... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addUnitDeptLink(tmp);
}

    @Override
    public void removeUnitDeptLink(UnitDeptLink... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeUnitDeptLink(tmp);
}

    public UnitDTO() {
}

    public UnitDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof Unit)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        Unit sourceCopy = (Unit)source;

        setName(sourceCopy.getName());

        setAddress(sourceCopy.getAddress());

        setFullName(sourceCopy.getFullName());

        Set<String> unitDeptLink = sourceCopy.getUnitDeptLink();
        if (unitDeptLink != null){
            setUnitDeptLink(new LinkedHashSet<String>(unitDeptLink));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //UnitDTO
