/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class AgentSkillAbstract extends BusinessEntityImpl implements AgentSkill {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionAgentSkill;

    private static final long serialVersionUID = 7220223919040521317L;

    @Override
    public String getComment() {
String value = AgentSkillHelper.getComment(getWikitty());
return value;
}

    @Override
    public void setComment(String comment) {
String oldValue = getComment();
AgentSkillHelper.setComment(getWikitty(), comment);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_COMMENT, oldValue, getComment());
}

    @Override
    public String getNature() {
String value = AgentSkillHelper.getNature(getWikitty());
return value;
}

    @Override
    public void setNature(String nature) {
String oldValue = getNature();
AgentSkillHelper.setNature(getWikitty(), nature);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_NATURE, oldValue, getNature());
}

    @Override
    public Nature getNature(boolean exceptionIfNotLoaded) {
Nature value = AgentSkillHelper.getNature(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setNature(Nature nature) {
Nature oldValue = getNature(false);
AgentSkillHelper.setNature(getWikitty(), nature);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_NATURE, oldValue, getNature());
}

    @Override
    public String getTechnicalSkill() {
String value = AgentSkillHelper.getTechnicalSkill(getWikitty());
return value;
}

    @Override
    public void setTechnicalSkill(String technicalSkill) {
String oldValue = getTechnicalSkill();
AgentSkillHelper.setTechnicalSkill(getWikitty(), technicalSkill);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL, oldValue, getTechnicalSkill());
}

    @Override
    public Skill getTechnicalSkill(boolean exceptionIfNotLoaded) {
Skill value = AgentSkillHelper.getTechnicalSkill(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setTechnicalSkill(Skill technicalSkill) {
Skill oldValue = getTechnicalSkill(false);
AgentSkillHelper.setTechnicalSkill(getWikitty(), technicalSkill);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL, oldValue, getTechnicalSkill());
}

    @Override
    public String getDomainSkill() {
String value = AgentSkillHelper.getDomainSkill(getWikitty());
return value;
}

    @Override
    public void setDomainSkill(String domainSkill) {
String oldValue = getDomainSkill();
AgentSkillHelper.setDomainSkill(getWikitty(), domainSkill);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL, oldValue, getDomainSkill());
}

    @Override
    public Skill getDomainSkill(boolean exceptionIfNotLoaded) {
Skill value = AgentSkillHelper.getDomainSkill(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setDomainSkill(Skill domainSkill) {
Skill oldValue = getDomainSkill(false);
AgentSkillHelper.setDomainSkill(getWikitty(), domainSkill);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL, oldValue, getDomainSkill());
}

    @Override
    public String getFrequency() {
String value = AgentSkillHelper.getFrequency(getWikitty());
return value;
}

    @Override
    public void setFrequency(String frequency) {
String oldValue = getFrequency();
AgentSkillHelper.setFrequency(getWikitty(), frequency);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_FREQUENCY, oldValue, getFrequency());
}

    @Override
    public Frequency getFrequency(boolean exceptionIfNotLoaded) {
Frequency value = AgentSkillHelper.getFrequency(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setFrequency(Frequency frequency) {
Frequency oldValue = getFrequency(false);
AgentSkillHelper.setFrequency(getWikitty(), frequency);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_FREQUENCY, oldValue, getFrequency());
}

    @Override
    public String getAgent() {
String value = AgentSkillHelper.getAgent(getWikitty());
return value;
}

    @Override
    public void setAgent(String agent) {
String oldValue = getAgent();
AgentSkillHelper.setAgent(getWikitty(), agent);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_AGENT, oldValue, getAgent());
}

    @Override
    public Agent getAgent(boolean exceptionIfNotLoaded) {
Agent value = AgentSkillHelper.getAgent(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setAgent(Agent agent) {
Agent oldValue = getAgent(false);
AgentSkillHelper.setAgent(getWikitty(), agent);
getPropertyChangeSupport().firePropertyChange(AgentSkill.FIELD_AGENTSKILL_AGENT, oldValue, getAgent());
}

    public AgentSkillAbstract() {
        super();
}

    public AgentSkillAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public AgentSkillAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionAgentSkill = new WikittyExtension(EXT_AGENTSKILL,
                "4.0", // version
                WikittyUtil.tagValuesToMap(" version=\"4.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String comment", 
                                             "Wikitty nature allowed=\"Nature\"", 
                                             "Wikitty technicalSkill allowed=\"Skill\"", 
                                             "Wikitty domainSkill allowed=\"Skill\"", 
                                             "Wikitty frequency allowed=\"Frequency\"", 
                                             "Wikitty agent allowed=\"Agent\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionAgentSkill);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return AgentSkillHelper.toString(getWikitty());
}

} //AgentSkillAbstract
