/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: UserForm.java 238 2011-09-28 16:47:25Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/users/UserForm.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.users;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.datepicker.client.DateBox;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Unit;
import fr.inra.refcomp.entities.User;
import fr.inra.refcomp.client.constants.FormContent;
import fr.inra.refcomp.services.InvalidEntityException;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 29 nov. 2010
 */
public class UserForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("UserForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, UserForm> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private static final RefcompMessages messages = GWT.create(RefcompMessages.class);

    public static final String ADMIN_CONTEXT = "admin";
    public static final String USER_CONTEXT = "user";

    String context;

    @UiField
    TextBox lastNameBox;

    @UiField
    TextBox firstNameBox;

    @UiField
    TextBox loginBox;

    @UiField
    PasswordTextBox passwordBox;

    @UiField
    PasswordTextBox passwordBoxConfirmation;

    @UiField
    TextBox emailBox;

    @UiField
    TextArea commentBox;

    @UiField
    TextBox refNumberBox;

    @UiField
    ListBox catiBox;

    @UiField
    ListBox unitBox;

    @UiField
    TextBox pepiBox;

    @UiField
    CheckBox agentBox;

    @UiField
    CheckBox adminBox;

    @UiField
    ListBox departmentBox;

    @UiField
    Anchor catiMail;

    @UiField
    Anchor departmentMail;

    @UiField
    Anchor error;

    @UiField
    Anchor unitMail;

    @UiField
    TextBox addressBox;

    @UiField
    TextBox stateBox;

    @UiField
    DateBox stateDateBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    @UiField
    TextBox jobTypeReferenceBox;

    @UiField
    TextBox jobTypeNameBox;

    User bean;

    Agent agentBean;

    /**
     * Manage the click on the agent checkbox (agentBox)
     * @param event the click event received
     */
    @UiHandler("agentBox")
    void doClickAgentBox(ClickEvent event) {
        boolean checked = ((CheckBox) event.getSource()).getValue();

        if(checked){
            service.setAgent(bean, new RefcompCallBack<Agent>(){
                @Override
                public void onSuccess(Agent result) {
                    agentBean = result;
                    refNumberBox.setValue(result.getRefNumber());

                    setEnabledAgentBoxes(true);
                    populateAndSelectUnitBox(result.getUnit());
                    populateAndSelectCatiBox(result.getCati());
                    populateAndSelectDepartmentBox(result.getDepartment());

                }
            });
        } else {
            setEnabledAgentBoxes(false);
            agentBean=null;
            service.unsetAgent(bean.getWikittyId(), new RefcompCallBack<Void>(){
                @Override
                public void onSuccess(Void result) {
                    refNumberBox.setValue("");
                    unselect(catiBox);
                    unselect(departmentBox);
                    unselect(unitBox);
                }
            });

        }
    }

    @UiHandler("sendPassword")
    public void sendPassword(ClickEvent event){
        service.sendPassword(bean.getWikittyId(), new RefcompCallBack<Boolean>() {
            @Override
            public void onSuccess(Boolean result) {
                if(result) {
                    Window.alert(messages.passwordMailSent());
                } else {
                    Window.alert(messages.passwordMailError());
                }
            }
        });
    }

    protected void setEnabledUserBoxes(Boolean enabled){
        lastNameBox.setEnabled(enabled);
        firstNameBox.setEnabled(enabled);
        loginBox.setEnabled(enabled);
        passwordBox.setEnabled(enabled);
        passwordBoxConfirmation.setEnabled(enabled);
        emailBox.setEnabled(enabled);
        commentBox.setEnabled(enabled);
        agentBox.setEnabled(enabled);
    }

    /**
     * Set enabled/disabled all the agent Text and ListBoxes
     * @param enabled true to enable the boxes
     */
    protected void setEnabledAgentBoxes(Boolean enabled) {
        refNumberBox.setEnabled(enabled);
        catiBox.setEnabled(enabled);
        departmentBox.setEnabled(enabled);
        unitBox.setEnabled(enabled);
        adminBox.setEnabled(enabled);
        addressBox.setEnabled(enabled);
        stateBox.setEnabled(enabled);
        stateDateBox.setEnabled(enabled);
        jobTypeNameBox.setEnabled(enabled);
        jobTypeReferenceBox.setEnabled(enabled);
        pepiBox.setEnabled(enabled);
    }

    public UserForm(String context) {
        initWidget(binder.createAndBindUi(this));

        this.context = context;

        service.getAdminEmail(new RefcompCallBack<String>() {
            @Override
            public void onSuccess(String s) {
                catiMail.setHref("mailto:"+s+"?subject=[Refcomp]Cati not existing");
                unitMail.setHref("mailto:"+s+"?subject=[Refcomp]Unit not existing");
                departmentMail.setHref("mailto:"+s+"?subject=[Refcomp]Department not existing");
            }
        });

        DateBox.Format dateFormat = new DateBox.DefaultFormat(
                DateTimeFormat.getFormat("dd/MM/yyyy"));
        stateDateBox.setFormat(dateFormat);

    }


    @Override
    public void setContent(BusinessEntity bean) {
        clearContent();

        if ((bean != null) && (bean instanceof User)) {
            this.bean = (User) bean;

            lastNameBox.setText(this.bean.getLastName());
            firstNameBox.setText(this.bean.getFirstName());
            loginBox.setText(this.bean.getLogin());
            passwordBox.setText(this.bean.getPassword());
            passwordBoxConfirmation.setText(this.bean.getPassword());
            emailBox.setText(this.bean.getEmail());
            commentBox.setText(this.bean.getComment());

            setEnabledUserBoxes(true);

            service.getAgent(bean.getWikittyId(), new RefcompCallBack<Agent>(){
                @Override
                public void onSuccess(Agent result){
                    if (result != null) {
                        agentBean = result;

                        setEnabledAgentBoxes(true);

                        agentBox.setValue(true);
                        refNumberBox.setValue(result.getRefNumber());
                        addressBox.setValue(result.getAddress());
                        stateBox.setValue(result.getState());
                        stateDateBox.setValue(result.getStateDate());
                        jobTypeNameBox.setValue(result.getJobType());
                        jobTypeReferenceBox.setValue(result.getJobTypeReference());
                        pepiBox.setValue(result.getPepi());

                        populateAndSelectUnitBox(result.getUnit());
                        populateAndSelectCatiBox(result.getCati());
                        populateAndSelectDepartmentBox(result.getDepartment());
                        service.isAdmin(result.getWikittyId(),
                                new RefcompCallBack<Boolean>(){
                                    @Override
                                    public void onSuccess(Boolean result) {
                                        adminBox.setValue(result);
                                    }
                                });
                    } else {
                        agentBox.setValue(false);
                    }
                }
            });
        }

        if ((bean != null) && (bean instanceof Agent)) {
            this.bean = (User) bean;

            lastNameBox.setText(this.bean.getLastName());
            firstNameBox.setText(this.bean.getFirstName());
            loginBox.setText(this.bean.getLogin());
            passwordBox.setText(this.bean.getPassword());
            passwordBoxConfirmation.setText(this.bean.getPassword());
            emailBox.setText(this.bean.getEmail());
            commentBox.setText(this.bean.getComment());

            setEnabledUserBoxes(true);

            this.agentBean = (Agent)bean;
            if (this.agentBean.getAgent()) {

                setEnabledAgentBoxes(true);

                agentBox.setValue(true);
                refNumberBox.setValue(this.agentBean.getRefNumber());
                addressBox.setValue(this.agentBean.getAddress());
                stateBox.setValue(this.agentBean.getState());
                stateDateBox.setValue(this.agentBean.getStateDate());

                populateAndSelectUnitBox(this.agentBean.getUnit());
                populateAndSelectCatiBox(this.agentBean.getCati());
                populateAndSelectDepartmentBox(this.agentBean.getDepartment());
            } else {
                agentBox.setValue(false);
            }
        }

        //Do not show error panel
        errorPanel.setVisible(false);
    }

    protected void populateAndSelectUnitBox(final Set<String> values) {
        service.getUnits(new RefcompCallBack<List<Unit>>() {
            @Override
            public void onSuccess(List<Unit> result) {
                unitBox.clear();
                for (Unit unit : result) {
                    String text = unit.getName();
                    String fullName = unit.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    unitBox.addItem(text, unit.getWikittyId());
                }
                select(unitBox, values);
            }
        });

    }

    protected void populateAndSelectCatiBox(final String value) {
        service.getCatis(new RefcompCallBack<List<Cati>>(){
            @Override
            public void onSuccess(List<Cati> result){
                catiBox.clear();
                for(Cati cati:result){
                    String text = cati.getName();
                    String fullName = cati.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    catiBox.addItem(text, cati.getWikittyId());
                }
                select(catiBox, value);
            }
        });
    }

    protected void populateAndSelectDepartmentBox(final String value) {
        service.getDepartments(new RefcompCallBack<List<Department>>() {
            @Override
            public void onSuccess(List<Department> result) {
                departmentBox.clear();
                for (Department department : result) {
                    String text = department.getName();
                    String fullName = department.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    departmentBox.addItem(text, department.getWikittyId());
                }
                select(departmentBox, value);
            }
        });
    }

    protected void select(ListBox box, String item){
        int itemCount = box.getItemCount();

        for (int i=0;i<itemCount;i++){
            String value = box.getValue(i);
            if (item.equals(value)){
                box.setSelectedIndex(i);
                break;
            }
        }
    }

    protected void select(ListBox box, Set<String> item) {
        int itemCount = box.getItemCount();

        for (int i = 0; i < itemCount; i++) {
            if (item.contains(box.getValue(i))) {
                box.setItemSelected(i, true);
            }
        }
    }

    protected void unselect(ListBox box) {
        int itemCount = box.getItemCount();

        for (int i = 0; i < itemCount; i++) {
            box.setItemSelected(i,false);
        }
    }

    @Override
    public void clearContent() {
        bean = null;
        agentBean = null;
        lastNameBox.setText("");
        firstNameBox.setText("");
        loginBox.setText("");
        passwordBox.setText("");
        passwordBoxConfirmation.setText("");
        emailBox.setText("");
        commentBox.setText("");
        refNumberBox.setText("");
        addressBox.setText("");
        stateBox.setText("");
        stateDateBox.setValue(null);
        jobTypeNameBox.setText("");
        jobTypeReferenceBox.setText("");
        agentBox.setValue(false);
        setEnabledUserBoxes(false);
        setEnabledAgentBoxes(false);
        adminBox.setValue(false);
        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {

        BusinessEntity editedBean = null;

        if (bean != null) {
            bean.setLastName(lastNameBox.getText());
            bean.setFirstName(firstNameBox.getText());
            bean.setLogin(loginBox.getText());
            bean.setPassword(passwordBox.getText());
            bean.setEmail(emailBox.getText());
            bean.setComment(commentBox.getText());

            editedBean = bean;
        }

        if (agentBean != null) {
            agentBean.setLastName(lastNameBox.getText());
            agentBean.setFirstName(firstNameBox.getText());
            agentBean.setLogin(loginBox.getText());
            agentBean.setPassword(passwordBox.getText());
            agentBean.setEmail(emailBox.getText());
            agentBean.setComment(commentBox.getText());
            agentBean.setRefNumber(refNumberBox.getText());
            agentBean.setAddress(addressBox.getText());
            agentBean.setState(stateBox.getText());
            agentBean.setStateDate(stateDateBox.getValue());
            agentBean.setJobType(jobTypeNameBox.getValue());
            agentBean.setJobTypeReference(jobTypeReferenceBox.getValue());
            agentBean.setPepi(pepiBox.getValue());
            if (catiBox.getItemCount()>0) {
                Integer selectedIndex = catiBox.getSelectedIndex();
                agentBean.setCati(catiBox.getValue(selectedIndex));
            }
            if (departmentBox.getItemCount() > 0) {
                int selectedIndex = departmentBox.getSelectedIndex();
                agentBean.setDepartment(departmentBox.getValue(selectedIndex));
            }
            if (unitBox.getItemCount() > 0) {
                agentBean.setUnit(getSelectedItems(unitBox));
            }

            editedBean = agentBean;
        }

        return editedBean;
    }

    @Override
    public void saveContent(Boolean creation) {

        String password = passwordBox.getText();
        String confirmation = passwordBoxConfirmation.getText();

        if (confirmation != null && password != null &&
                confirmation.equals(password)) {

            boolean validate = Window.confirm(messages.sure());

            if (validate) {

                errorPanel.setVisible(false);

                if (agentBox.getValue()){
                    Agent agent = (Agent) getContent();
                    //First save agent
                    service.saveAgent(agent, context,
                            new RefcompCallBack<Agent>() {
                                @Override
                                public void onSuccess(Agent result) {
                                    //then set him admin if needed
                                    service.setAdmin(result.getWikittyId(),
                                            adminBox.getValue(),
                                            new RefcompCallBack<Void>() {
                                                @Override
                                                public void onSuccess(Void result) {
                                                    AdminUsers.refresh();
                                                }
                                            });
                                }


                                @Override
                                public void onFailure(Throwable caught) {
                                    if (caught instanceof InvalidEntityException) {
                                        History.newItem("error");
                                        errorPanel.setVisible(true);
                                        errorLabel.setText(caught.getMessage());



                                    } else {
                                        Window.alert(messages.exception());
                                    }
                                }
                            });
                } else {
                    service.saveUser((User) getContent(), context,
                            new RefcompCallBack<User>() {
                                @Override
                                public void onSuccess(User result) {
                                    setContent(result);
                                    AdminUsers.refresh();
                                }

                                @Override
                                public void onFailure(Throwable caught) {
                                    if (caught instanceof InvalidEntityException) {
                                        errorPanel.setVisible(true);
                                        errorLabel.setText(caught.getMessage());
                                    } else {
                                        Window.alert(messages.exception());
                                    }
                                }
                            });
                }
            }
        } else {
            errorPanel.setVisible(true);
            errorLabel.setText(messages.wrongPassword());
        }
    }

    @Override
    public void cancelContent(Boolean creation) {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            clearContent();
        }
    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            service.deleteUser((User) getContent(),
                    new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminUsers.refresh();
                        }
                    });
        }
    }

    /**
     * Method to get all the selected items value of a list box (useful only
     * for multi-selection ListBoxes. For simple selection ListBoxes, use
     * getSelectedIndex method.
     *
     * @param box the box to get the selection from.
     * @return the values of the selected items.
     */
    protected Set<String> getSelectedItems(ListBox box){

        Set<String> selectedItems = new HashSet<String>();

        int itemCount = box.getItemCount();

        for (int i=0;i<itemCount;i++){
            if (box.isItemSelected(i)){
                selectedItems.add(box.getValue(i));
            }
        }

        return selectedItems;

    }

    public void setMyAccountMode() {

        final Element parentElement = agentBox.getElement().getParentElement();
        parentElement.setClassName("hide");

        adminBox.setVisible(false);

    }

    private class AnchorClickEvent extends ClickEvent {
        /*To call click() function for Programmatic equivalent of the user clicking the button.*/
    }
}
