/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.SaveCatchBatchAction;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Dialog;
import java.io.File;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.apache.commons.collections4.MapUtils;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public abstract class ImportMultiPostActionSupport<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends LongActionSupport<M, UI, H> {
    private Boolean doSaveCatches;
    private Boolean doResetCatches;
    private File file;
    private Map<String, Object> notImportedData;

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    protected abstract String getSuccessMessage(File var1);

    protected abstract Map<String, Object> importBatches(MultiPostImportService var1, File var2, FishingOperation var3);

    public ImportMultiPostActionSupport(H handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            boolean canSave;
            this.doResetCatches = this.doSaveCatches = Boolean.valueOf(false);
            EditCatchesUI catchesUI = this.getEditCatchUI();
            EditCatchesUIModel model = catchesUI.getModel();
            boolean bl = canSave = model.isModify() && model.isValid();
            if (canSave) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.askToSaveCatch.message", (Object[])new Object[0]), I18n.t((String)"tutti.askToSaveCatchBeforeImport.help", (Object[])new Object[0]));
                int saveResponse = JOptionPane.showOptionDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"tutti.askToSaveCatch.title", (Object[])new Object[0]), 2, 3, null, new String[]{I18n.t((String)"tutti.option.saveCatch", (Object[])new Object[0]), I18n.t((String)"tutti.option.resetCatch", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancelImport", (Object[])new Object[0])}, I18n.t((String)"tutti.option.saveCatch", (Object[])new Object[0]));
                switch (saveResponse) {
                    case 0: {
                        this.doSaveCatches = true;
                        break;
                    }
                    case 1: {
                        this.doResetCatches = true;
                        break;
                    }
                    case 2: {
                        doAction = false;
                    }
                }
            }
            if (doAction) {
                this.file = this.chooseFile(this.getFileChooserTitle(), this.getFileChooserButton(), new String[]{"^.*\\." + this.getFileExtension(), this.getFileExtensionDescription()});
                doAction = this.file != null;
            }
        }
        return doAction;
    }

    public final void releaseAction() {
        this.file = null;
        this.doSaveCatches = null;
        this.doResetCatches = null;
        this.notImportedData = null;
        super.releaseAction();
    }

    @Override
    public final void doAction() throws Exception {
        ProgressionModel progressionModel;
        EditCatchesUI editCatchesUI = this.getEditCatchUI();
        EditCatchesUIModel editCatchesUIModel = editCatchesUI.getModel();
        FishingOperation operation = editCatchesUIModel.getFishingOperation();
        if (this.doSaveCatches.booleanValue()) {
            this.setProgressionModel(new ProgressionModel());
            progressionModel = this.getProgressionModel();
            progressionModel.setTotal(2);
            progressionModel.increments("Sauvegarde de la capture");
            this.getActionEngine().runInternalAction((AbstractApplicationUIHandler)editCatchesUI.getHandler(), SaveCatchBatchAction.class);
        } else if (this.doResetCatches.booleanValue()) {
            this.setProgressionModel(new ProgressionModel());
            progressionModel = this.getProgressionModel();
            progressionModel.setTotal(2);
            progressionModel.increments("R\u00e9initilisation de la capture");
            editCatchesUI.getHandler().getCatchBatchMonitor().clearModified();
            progressionModel.increments("Lancement de l'import");
        }
        MultiPostImportService multiPostImportExportService = this.getContext().getMultiPostImportService();
        this.notImportedData = this.importBatches(multiPostImportExportService, this.file, operation);
        FishingOperationsUI parentUI = (FishingOperationsUI)((TuttiUI)this.getUI()).getParentContainer(FishingOperationsUI.class);
        EditFishingOperationAction editAction = (EditFishingOperationAction)this.getActionFactory().createLogicAction((AbstractApplicationUIHandler)parentUI.getHandler(), EditFishingOperationAction.class);
        editAction.loadCatchBatch(operation);
    }

    public void postSuccessAction() {
        String text;
        super.postSuccessAction();
        if (MapUtils.isNotEmpty(this.notImportedData) && !(text = this.buildNotImportedDataReportText(this.notImportedData)).isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog)this.getContext().getActionUI());
            JTextArea batchList = dialog.getBatchList();
            batchList.setText(text);
            dialog.setSize(400, 300);
            dialog.setLocationRelativeTo(this.getContext().getMainUI());
            dialog.setVisible(true);
        }
        this.sendMessage(this.getSuccessMessage(this.file));
    }

    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        throw new IllegalStateException("Override this to use it");
    }

    protected EditCatchesUI getEditCatchUI() {
        return (EditCatchesUI)((TuttiUI)this.getUI()).getParentContainer(EditCatchesUI.class);
    }

    protected void addNotImportedWeightToReport(StringBuilder builder, Float weight, WeightUnit weightUnit, String label) {
        if (weight != null) {
            builder.append("- ").append(I18n.t((String)label, (Object[])new Object[]{weightUnit.fromEntity(weight), weightUnit.getShortLabel()})).append("\n");
        }
    }
}

