/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.caliper.feed.CaliperFeedReader;
import fr.ifremer.tutti.ichtyometer.feed.IchtyometerFeedReader;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUI;
import fr.ifremer.tutti.ui.swing.content.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, MainUI> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected JComponent currentBody;

    public void reloadDbManagerText() {
        TuttiUI body = (TuttiUI)((Object)this.currentBody);
        if (body != null && body.getHandler() instanceof DbManagerUIHandler) {
            DbManagerUIHandler dbManagerUIHandler = (DbManagerUIHandler)body.getHandler();
            dbManagerUIHandler.updateMessage();
        }
    }

    public String getIchtyometerStatusTip(boolean connected) {
        String result;
        if (connected) {
            IchtyometerFeedReader ichtyometerReader = ((TuttiUIContext)this.getModel()).getIchtyometerReader();
            result = I18n.t((String)"tutti.ichtyometer.status.connected.tip", (Object[])new Object[]{ichtyometerReader.getClientName()});
        } else {
            result = I18n.t((String)"tutti.ichtyometer.status.not.connected.tip", (Object[])new Object[0]);
        }
        return result;
    }

    public String getCaliperStatusLabel(boolean connected) {
        String result = null;
        if (connected) {
            CaliperFeedReader caliperReader = ((TuttiUIContext)this.getModel()).getCaliperReader();
            result = caliperReader.getSerialPortName();
        }
        return result;
    }

    public String getCaliperStatusTip(boolean connected) {
        String result;
        if (connected) {
            CaliperFeedReader caliperReader = ((TuttiUIContext)this.getModel()).getCaliperReader();
            result = I18n.t((String)"tutti.caliper.status.connected.tip", (Object[])new Object[]{caliperReader.getSerialPortName()});
        } else {
            result = I18n.t((String)"tutti.caliper.status.not.connected.tip", (Object[])new Object[0]);
        }
        return result;
    }

    public void beforeInit(MainUI ui) {
        super.beforeInit((ApplicationUI)ui);
        TuttiUIContext context = this.getContext();
        ui.setContextValue(context);
        context.setMainUI(ui);
        context.setActionUI(new ApplicationActionUI((JFrame)ui, (ApplicationUIContext)context));
        context.addPropertyChangeListener(new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (TuttiUIContext.PROPERTIES_TO_SAVE.contains(propertyName)) {
                    if ("cruiseId".equals(propertyName)) {
                        MainUIHandler.this.getDataContext().resetCruise();
                    }
                    if ("protocolId".equals(propertyName)) {
                        MainUIHandler.this.getDataContext().resetProtocol();
                    }
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
        ui.setContextValue(ui, MainUI.class.getName());
        context.addPropertyChangeListener("busy", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                MainUIHandler.this.updateBusyState(newvalue != null && newvalue != false);
            }
        });
        context.addPropertyChangeListener("hideBody", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                if (MainUIHandler.this.getUI() != null && ((MainUI)MainUIHandler.this.getUI()).getBody() != null) {
                    ((MainUI)MainUIHandler.this.getUI()).getBody().setVisible(newvalue != null && newvalue != false);
                }
            }
        });
    }

    protected void updateBusyState(boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getDefaultCursor());
        }
    }

    public void afterInit(MainUI ui) {
        this.initUI(ui);
        SwingUtil.setLayerUI((JComponent)ui.getBody(), (LayerUI)ui.getBusyBlockLayerUI());
        ui.applyDataBinding("menuChangeLocaleFR.enabled");
        ui.applyDataBinding("menuChangeLocaleUK.enabled");
        this.getContext().addInSwingSession(ui, false);
        this.changeTitle();
        JToolBar bar = ui.getBottomBar();
        ui.getStatus().addWidget((Component)bar, 0);
    }

    protected JComponent getComponentToFocus() {
        return this.currentBody;
    }

    public void onCloseUI() {
        PropertyChangeListener[] propertyChangeListeners;
        TuttiUIContext context = this.getContext();
        context.setScreen(null);
        context.removeMessageNotifier(this);
        for (PropertyChangeListener listener : propertyChangeListeners = context.getPropertyChangeListeners()) {
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                listener = (PropertyChangeListener)proxy.getListener();
            }
            if (!(listener instanceof RemoveablePropertyChangeListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            context.removePropertyChangeListener(listener);
        }
        if (this.ui != null) {
            JAXXBinding[] bindings;
            for (JAXXBinding binding : bindings = ((MainUI)this.ui).getDataBindings()) {
                SwingUtil.removeDataBinding((JAXXObject)this.ui, (String[])new String[]{binding.getId()});
            }
            ((MainUI)this.ui).setVisible(false);
            ((MainUI)this.ui).dispose();
        }
    }

    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void reloadUI() {
        this.onCloseUI();
        RunTutti.startTutti(this.getContext(), false);
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    @Override
    public final void showInformationMessage(String message) {
        ((MainUI)this.ui).getStatus().setStatus("<html><body>" + message + "</body></html>");
    }

    public void registerValidator(SwingValidator validator) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Register validator: " + validator.getType() + " - " + validator.getContext() + " (" + validator + ")"));
        }
        ((MainUI)this.ui).getValidatorMessageWidget().registerValidator(validator);
    }

    @Override
    public void clearValidators() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Clean all registred validators.");
        }
        ((MainUI)this.ui).getValidatorMessageWidget().clearValidators();
    }

    public boolean quitCurrentScreen() {
        boolean canClose;
        if (this.getContext().getScreen() == null || this.currentBody == null) {
            canClose = true;
            if (log.isWarnEnabled()) {
                log.warn((Object)"==================================================");
                log.warn((Object)"No screen, Should then skipCheckCurrent in action.");
                log.warn((Object)"==================================================");
            }
        } else {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            Preconditions.checkNotNull((Object)this.currentBody);
            AbstractApplicationUIHandler handler = body.getHandler();
            canClose = handler instanceof CloseableUI ? ((CloseableUI)handler).quitUI() : true;
        }
        return canClose;
    }

    protected void setScreen(TuttiScreen screen) {
        TuttiUIContext context = this.getContext();
        if (this.currentBody != null) {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            body.getHandler().onCloseUI();
            context.saveSwingSession();
            ((MainUI)this.ui).getBody().remove((Component)this.currentBody);
            this.currentBody = null;
        }
        if (screen != null) {
            Icon icon;
            String screenTitle;
            JComponent screenUI;
            JToolBar rightDecoration = null;
            switch (screen) {
                case CONFIG: {
                    screenUI = new TuttiConfigUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.config.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileConfiguration().getIcon();
                    break;
                }
                case EDIT_SAMPLE_CATEGORY_MODEL: {
                    screenUI = new EditSampleCategoryModelUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.editSampleCategoryModel.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuEditSampleCategoryModel().getIcon();
                    break;
                }
                default: {
                    screenUI = new DbManagerUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.dbMabager.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileManageDb().getIcon();
                    break;
                }
                case SELECT_CRUISE: {
                    screenUI = new SelectCruiseUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.selectCruise.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionSelectCruise().getIcon();
                    break;
                }
                case EDIT_PROGRAM: {
                    screenTitle = EditProgramUIHandler.getTitle(context.isProgramFilled());
                    screenUI = new EditProgramUI((TuttiUI)this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProgram().getIcon();
                    break;
                }
                case EDIT_CRUISE: {
                    screenTitle = EditCruiseUIHandler.getTitle(context.isCruiseFilled());
                    screenUI = new EditCruiseUI((TuttiUI)this.ui);
                    rightDecoration = ((EditCruiseUI)screenUI).getTopToolBar();
                    Cruise cruise = context.getDataContext().getCruise();
                    icon = TuttiUIUtil.getCruiseIcon(cruise == null ? ((EditCruiseUI)screenUI).getModel() : cruise);
                    break;
                }
                case EDIT_PROTOCOL: {
                    screenTitle = EditProtocolUIHandler.getTitle(context.isProtocolFilled());
                    screenUI = new EditProtocolUI((TuttiUI)this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProtocol().getIcon();
                    break;
                }
                case EDIT_FISHING_OPERATION: {
                    screenTitle = I18n.t((String)"tutti.fishingOperations.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                    icon = ((MainUI)this.ui).getMenuActionEditCatches().getIcon();
                    screenUI = new FishingOperationsUI((TuttiUI)this.ui);
                    break;
                }
                case IMPORT_TEMPORARY_REFERENTIAL: {
                    screenTitle = I18n.t((String)"tutti.manageTemporaryReferential.title", (Object[])new Object[0]);
                    screenUI = new ManageTemporaryReferentialUI((TuttiUI)this.ui);
                    icon = ((MainUI)this.ui).getMenuImportTemporaryReferential().getIcon();
                    break;
                }
                case VALIDATE_CRUISE: {
                    screenUI = new ValidateCruiseUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.fishingOperations.title.validate.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                    icon = ((MainUI)this.ui).getMenuActionValidateCatches().getIcon();
                    break;
                }
                case REPORT: {
                    screenUI = new ReportUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.report.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionGenerateCruiseReport().getIcon();
                    break;
                }
                case GENERIC_FORMAT_IMPORT: {
                    screenUI = new GenericFormatImportUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.genericFormatImport.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionGenericFormatImport().getIcon();
                    break;
                }
                case GENERIC_FORMAT_EXPORT: {
                    screenUI = new GenericFormatExportUI((TuttiUI)this.ui);
                    screenTitle = I18n.t((String)"tutti.genericFormatExport.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionGenericFormatExport().getIcon();
                }
            }
            JButton showHelp = ((MainUI)this.ui).getShowHelp();
            if (rightDecoration == null) {
                rightDecoration = new JToolBar();
                rightDecoration.setFloatable(false);
                rightDecoration.setOpaque(false);
                rightDecoration.setBorderPainted(false);
            } else {
                rightDecoration.remove(showHelp);
            }
            rightDecoration.add((Component)showHelp, 0);
            this.currentBody = screenUI;
            context.addInSwingSession(this.currentBody, true);
            ((MainUI)this.ui).getBody().setTitle(screenTitle);
            ((MainUI)this.ui).getBody().add((Component)this.currentBody);
            ((MainUI)this.ui).getBody().setLeftDecoration((JComponent)new JLabel(icon));
            ((MainUI)this.ui).getBody().setRightDecoration((JComponent)rightDecoration);
            ((MainUI)this.ui).getBody().getRightDecoration().setVisible(true);
        }
    }

    public void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        ((MainUI)this.ui).setTitle(I18n.t((String)"tutti.main.title.application", (Object[])new Object[]{this.getConfig().getVersion(), title}));
    }

    protected String getSelectedCruiseTitle() {
        String title;
        TuttiUIContext context = this.getContext();
        if (context.isDbLoaded()) {
            if (context.isProgramFilled()) {
                Program program = this.getDataContext().getProgram();
                title = I18n.t((String)"tutti.main.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
                if (context.isCruiseFilled()) {
                    Cruise cruise = this.getDataContext().getCruise();
                    if (cruise != null) {
                        title = title + I18n.t((String)"tutti.main.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
                    }
                } else {
                    title = title + I18n.t((String)"tutti.main.title.noSelectedCruise", (Object[])new Object[0]);
                }
            } else {
                title = I18n.t((String)"tutti.main.title.noSelectedProgram", (Object[])new Object[0]);
            }
            title = title + " / ";
            if (context.isProtocolFilled()) {
                TuttiProtocol protocol = this.getDataContext().getProtocol();
                title = title + I18n.t((String)"tutti.main.title.selectedProtocol", (Object[])new Object[]{protocol.getName()});
            } else {
                title = title + I18n.t((String)"tutti.main.title.noSelectedProtocol", (Object[])new Object[0]);
            }
        } else {
            title = I18n.t((String)"tutti.main.title.nodb", (Object[])new Object[0]);
        }
        return title;
    }

    public void setBodyTitle(String title) {
        ((MainUI)this.ui).getBody().setTitle(title);
    }

    public JComponent getCurrentBody() {
        return this.currentBody;
    }
}

