/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.Strata;
import fr.ifremer.tutti.persistence.entities.protocol.Stratas;
import fr.ifremer.tutti.persistence.entities.protocol.SubStrata;
import fr.ifremer.tutti.persistence.entities.protocol.SubStratas;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.protocol.Zones;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import org.springframework.stereotype.Service;

@Service(value="protocolPersistenceService")
public class ProtocolPersistenceServiceImpl
extends AbstractPersistenceService
implements ProtocolPersistenceService {
    private static final Log log = LogFactory.getLog(ProtocolPersistenceServiceImpl.class);
    public static final String TUTTI_PROTOCOL_EXTENSION = "tuttiProtocol";
    public static TuttiProtocol sharedProtocol;
    @Resource(name="cacheService")
    protected CacheService cacheService;

    @Override
    public TuttiProtocol getProtocol() {
        return sharedProtocol;
    }

    @Override
    public void setProtocol(TuttiProtocol protocol) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set shared protocol: " + protocol));
            }
            sharedProtocol = protocol;
            try {
                this.cacheService.clearCache("species");
                this.cacheService.clearCache("referentSpecies");
                this.cacheService.clearCache("referentSpeciesById");
                this.cacheService.clearCache("referentSpeciesByIdVernacular");
                this.cacheService.clearCache("obsoleteReferentTaxons");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not clear caches", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.getAllProtocolId().contains(id);
    }

    @Override
    public String getFirstAvailableName(String protocolName) {
        List<String> allProtocolNames = this.getAllProtocolNames();
        String availableName = allProtocolNames.contains(protocolName) ? TuttiProtocols.getFirstAvailableName(protocolName, allProtocolNames) : protocolName;
        return availableName;
    }

    @Override
    public TuttiProtocol getProtocolByName(String protocolName) {
        TuttiProtocol result = null;
        for (TuttiProtocol protocol : this.getAllProtocol()) {
            if (!protocolName.equals(protocol.getName())) continue;
            result = protocol;
        }
        return result;
    }

    @Override
    public List<String> getAllProtocolId() {
        File protocolDirectory = this.config.getProtocolDirectory();
        Collection files = FileUtils.listFiles((File)protocolDirectory, (String[])new String[]{TUTTI_PROTOCOL_EXTENSION}, (boolean)false);
        ArrayList result = Lists.newArrayListWithCapacity((int)files.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + files.size() + " protocol(s)."));
        }
        int suffixLength = TUTTI_PROTOCOL_EXTENSION.length() + 1;
        for (File file : files) {
            String fileName = file.getName();
            result.add(fileName.substring(0, fileName.length() - suffixLength));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getAllProtocolNames() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.getAllProtocol().stream().map(TuttiProtocol::getName).collect(Collectors.toList()));
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        ArrayList result = Lists.newArrayList();
        for (String id : this.getAllProtocolId()) {
            TuttiProtocol protocol = this.getProtocol(id);
            result.add(protocol);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiProtocol> getAllProtocol(String programId) {
        ArrayList result = Lists.newArrayList();
        for (String id : this.getAllProtocolId()) {
            TuttiProtocol protocol = this.getProtocol(id);
            if (TuttiProtocols.matchProgramId(protocol, programId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Keep protocol: " + protocol.getName() + ", programId: " + programId + " matches!"));
                }
                result.add(protocol);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Remove protocol: " + protocol.getName() + ", programId: " + programId + " does not match!"));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        File file = this.getProtocolFile(id);
        return TuttiProtocols.fromFile(file);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        Binder protocolBinder = BinderFactory.newBinder(TuttiProtocol.class);
        TuttiProtocol result = TuttiProtocols.newTuttiProtocol();
        protocolBinder.copy((Object)bean, (Object)result, new String[0]);
        result.setId(UUID.randomUUID().toString());
        result.setLengthClassesPmfmId(bean.getLengthClassesPmfmId());
        result.setCaracteristicMapping(bean.getCaracteristicMapping());
        Binder speciesProtocolBinder = BinderFactory.newBinder(SpeciesProtocol.class);
        ArrayList species = Lists.newArrayList();
        if (!bean.isSpeciesEmpty()) {
            for (SpeciesProtocol speciesProtocol : bean.getSpecies()) {
                SpeciesProtocol speciesProtocol2 = SpeciesProtocols.newSpeciesProtocol();
                speciesProtocolBinder.copy((Object)speciesProtocol, (Object)speciesProtocol2, new String[0]);
                speciesProtocol2.setId(UUID.randomUUID().toString());
                species.add(speciesProtocol2);
            }
        }
        result.setSpecies(species);
        ArrayList benthos = Lists.newArrayList();
        if (!bean.isBenthosEmpty()) {
            for (SpeciesProtocol speciesProtocol : bean.getBenthos()) {
                SpeciesProtocol s = SpeciesProtocols.newSpeciesProtocol();
                speciesProtocolBinder.copy((Object)speciesProtocol, (Object)s, new String[0]);
                s.setId(UUID.randomUUID().toString());
                benthos.add(s);
            }
        }
        result.setBenthos(benthos);
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        if (!bean.isZoneEmpty()) {
            for (Zone zone : bean.getZone()) {
                Zone z = Zones.newZone(zone);
                arrayList.add(z);
                ArrayList<Strata> stratas = new ArrayList<Strata>();
                if (!zone.isStrataEmpty()) {
                    for (Strata strata : zone.getStrata()) {
                        Strata s = Stratas.newStrata(strata);
                        stratas.add(s);
                        ArrayList<SubStrata> subStratas = new ArrayList<SubStrata>();
                        if (!strata.isSubstrataEmpty()) {
                            for (SubStrata subStrata : strata.getSubstrata()) {
                                SubStrata ss = SubStratas.newSubStrata(subStrata);
                                subStratas.add(ss);
                            }
                        }
                        s.setSubstrata(subStratas);
                    }
                }
                z.setStrata(stratas);
            }
        }
        result.setZone(arrayList);
        String string = result.getId();
        File file = this.getProtocolFile(string);
        TuttiProtocols.toFile(result, file);
        return result;
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        String id = bean.getId();
        File file = this.getProtocolFile(id);
        TuttiProtocols.toFile(bean, file);
        return bean;
    }

    @Override
    public void deleteProtocol(String protocolId) {
        File file = this.getProtocolFile(protocolId);
        if (file.exists()) {
            ApplicationIOUtil.deleteFile((File)file, (String)I18n.t((String)"tutti.persistence.protocol.delete.error", (Object[])new Object[]{protocolId, file}));
        }
    }

    protected File getProtocolFile(String id) {
        File protocolDirectory = this.config.getProtocolDirectory();
        return new File(protocolDirectory, id + "." + TUTTI_PROTOCOL_EXTENSION);
    }
}

