/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.referential.AbstractGears;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;

public class Gears
extends AbstractGears {
    public static final Predicate<Gear> IS_FISHING_GEAR = input -> !input.isScientificGear();
    public static final Predicate<Gear> IS_SCIENTIFIC_GEAR = Gear::isScientificGear;
    public static final Predicate<Gear> IS_TEMPORARY = Gears::isTemporary;
    public static final Function<Gear, String> GET_NAME = TuttiReferentialEntity::getName;

    public static boolean isTemporary(Gear gear) {
        Preconditions.checkNotNull((Object)gear);
        Preconditions.checkNotNull((Object)gear.getId());
        return TuttiReferentialEntities.isStatusTemporary(gear) && Gears.isTemporaryId(gear.getIdAsInt());
    }

    public static boolean isTemporaryId(Integer id) {
        Preconditions.checkNotNull((Object)id);
        return id < 0;
    }
}

