/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones.actions;

import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.ZoneEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.SubStrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddStratasAction
extends SimpleActionSupport<ZoneEditorUI> {
    private static final Log log = LogFactory.getLog(AddStratasAction.class);

    public AddStratasAction(ZoneEditorUI zoneEditorUI) {
        super(zoneEditorUI);
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onActionPerformed(ZoneEditorUI zoneEditorUI) {
        Optional<ZoneNode> optionalSelectedZoneNode = this.getSelectedZone(zoneEditorUI);
        if (!optionalSelectedZoneNode.isPresent()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No zone selected");
            }
            return;
        }
        JTree availableStratasTree = zoneEditorUI.getAvailableStratasTree();
        TreePath[] selectedAvailableStrataPaths = availableStratasTree.getSelectionPaths();
        if (selectedAvailableStrataPaths == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No available stratas, nor subStratas selected");
            }
            return;
        }
        Set<StrataNode> strataNodesToAdd = this.getStrataNodesToAdd(selectedAvailableStrataPaths);
        Set<SubStrataNode> subStrataNodesToAdd = this.getSubStrataNodesToAdd(selectedAvailableStrataPaths, strataNodesToAdd);
        ZoneNode selectedZoneNode = optionalSelectedZoneNode.get();
        EditProtocolUIModel model = zoneEditorUI.getModel();
        model.setModifyingZones(true);
        try {
            strataNodesToAdd.forEach(strataNode -> model.selectStrataNodes(selectedZoneNode, (StrataNode)strataNode));
            subStrataNodesToAdd.forEach(subStrataNode -> model.selectedSubStraNodes(selectedZoneNode, (SubStrataNode)subStrataNode));
        }
        finally {
            model.setModifyingZones(false);
        }
    }

    protected Optional<ZoneNode> getSelectedZone(ZoneEditorUI zoneEditorUI) {
        JTree zonesTree = zoneEditorUI.getZonesTree();
        TreePath selectedZonePath = zonesTree.getSelectionPath();
        return Optional.ofNullable(selectedZonePath == null ? null : (ZoneNode)selectedZonePath.getPathComponent(1));
    }

    protected Set<StrataNode> getStrataNodesToAdd(TreePath[] selectedStratas) {
        HashSet<StrataNode> result = new HashSet<StrataNode>();
        for (TreePath selectedStrata : selectedStratas) {
            Object node = selectedStrata.getLastPathComponent();
            if (!(node instanceof StrataNode)) continue;
            StrataNode strataNode = (StrataNode)node;
            if (log.isInfoEnabled()) {
                log.info((Object)("found strata " + strataNode + " to add"));
            }
            result.add(strataNode);
        }
        return result;
    }

    protected Set<SubStrataNode> getSubStrataNodesToAdd(TreePath[] selectedStratas, Set<StrataNode> stratasNodeToAdd) {
        LinkedHashSet<SubStrataNode> result = new LinkedHashSet<SubStrataNode>();
        for (TreePath selectedStrata : selectedStratas) {
            SubStrataNode subStrataNode;
            StrataNode strataNode;
            Object node = selectedStrata.getLastPathComponent();
            if (!(node instanceof SubStrataNode) || stratasNodeToAdd.contains(strataNode = (subStrataNode = (SubStrataNode)node).getParent())) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("found subStrata " + subStrataNode + " to add"));
            }
            result.add(subStrataNode);
        }
        return result;
    }
}

