/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import fr.ifremer.tutti.service.protocol.ProtocolCaracteristicsImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class LoadProtocolImportColumnsAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(LoadProtocolImportColumnsAction.class);
    protected File columnsFile;

    public LoadProtocolImportColumnsAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            this.columnsFile = this.chooseFile(I18n.t((String)"tutti.editProtocol.action.title.choose.importColumnsFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.chooseColumnsFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            result = this.columnsFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        ProtocolCaracteristicsImportExportService service = this.getContext().getProtocolCaracteristicsImportExportService();
        List columns = service.loadProtocolCaracteristicsImportColumns(this.columnsFile);
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected columns: " + columns));
        }
        ((EditProtocolUIModel)this.getModel()).setImportColumns(columns);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.editProtocol.action.loadImportColumns.success", (Object[])new Object[]{((EditProtocolUIModel)this.getModel()).sizeImportColumns()}));
    }
}

