/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportResult;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ImportMultiPostSpeciesSupportAction
extends LongActionSupport<SpeciesFrequencyUIModel, SpeciesFrequencyUI, SpeciesFrequencyUIHandler> {
    private static final Log log = LogFactory.getLog(ImportMultiPostSpeciesSupportAction.class);
    private File file;
    private MultiPostImportResult importResult;
    protected Float totalWeight;

    protected ImportMultiPostSpeciesSupportAction(SpeciesFrequencyUIHandler handler) {
        super(handler, false);
    }

    public abstract boolean isImportFrequencies();

    public abstract boolean isImportIndivudalObservations();

    protected abstract String getSuccessMessage(File var1);

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(this.getFileChooserTitle(), this.getFileChooserButton(), new String[]{"^.*\\." + this.getFileExtension(), this.getFileExtensionDescription()});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public final void doAction() throws Exception {
        FishingOperation operation = this.getDataContext().getFishingOperation();
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        SpeciesOrBenthosBatchUISupport batchUISupport = model.getSpeciesOrBenthosBatchUISupport();
        SpeciesBatch speciesBatch = model.getBatch().toEntity();
        this.totalWeight = model.getTotalWeight();
        this.importResult = batchUISupport.importMultiPost(this.file, operation, speciesBatch, this.isImportFrequencies(), this.isImportIndivudalObservations());
    }

    public final void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(this.getSuccessMessage(this.file));
        SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor = ((SpeciesFrequencyUIHandler)this.getHandler()).getFrequencyEditor();
        SpeciesBatchRowModel editRow = frequencyEditor.getEditRow();
        Integer speciesBatchId = editRow.getIdAsInt();
        List frequencies = this.importResult.getImportedFrequencies();
        if (log.isInfoEnabled()) {
            log.info((Object)("[SpeciesBatch: " + speciesBatchId + "] Frequencies: " + frequencies.size()));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        List<SpeciesFrequencyRowModel> frequencyRows = SpeciesFrequencyRowModel.fromEntity(model.getSpeciesOrBenthosBatchUISupport().getWeightUnit(), frequencies);
        List individualObservations = this.importResult.getImportedObservations();
        if (log.isInfoEnabled()) {
            log.info((Object)("[SpeciesBatch: " + speciesBatchId + "] Individual Observations: " + individualObservations.size()));
        }
        List<IndividualObservationBatchRowModel> individualObservationRows = IndividualObservationBatchRowModel.fromEntity(this.getConfig().getIndividualObservationWeightUnit(), this.getDataContext().getDefaultIndividualObservationCaracteristics(), individualObservations);
        model.clear();
        model.getIndividualObservationModel().clear();
        ((SpeciesFrequencyUIHandler)this.getHandler()).loadFrequenciesAndObservations(frequencyRows, individualObservationRows, true);
        if (this.totalWeight != null) {
            model.setTotalWeight(this.totalWeight);
        }
        if (!this.isImportFrequencies() && model.mustCopyIndividualObservationSize()) {
            model.getFrequencyTableModel().reloadRowsFromIndividualObservations();
        }
        model.setModify(true);
    }

    public final void releaseAction() {
        this.file = null;
        this.importResult = null;
        this.totalWeight = null;
        super.releaseAction();
    }
}

