/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class SelectSpeciesForSpeciesBatchAction
extends LongActionSupport<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI, CreateSpeciesBatchUIHandler> {
    protected List<Species> allSpecies = this.getDataContext().getSpecies();
    protected List<Species> referentSpecies = this.getDataContext().getReferentSpecies();
    protected Species selectedSpecies;
    protected List<Species> availableSpecies;

    public SelectSpeciesForSpeciesBatchAction(CreateSpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
            ArrayList<Species> species = new ArrayList<Species>(this.allSpecies);
            species.removeAll(model.getAvailableSpecies());
            this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpeciesForSpeciesBatch.title", (Object[])new Object[0]), species);
            canContinue = this.selectedSpecies != null;
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
        this.availableSpecies = new ArrayList<Species>(model.getAvailableSpecies());
        if (!this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies, "fromProtocol");
            List<Species> referents = this.referentSpecies;
            Map referentsById = Speciess.splitReferenceSpeciesByReferenceTaxonId(referents);
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = (Species)referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies, "fromProtocol");
            this.sendMessage(I18n.t((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        if (!this.availableSpecies.contains(this.selectedSpecies)) {
            this.availableSpecies.add(this.selectedSpecies);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
        model.setAvailableSpecies(this.availableSpecies);
        model.setSpecies(this.selectedSpecies);
    }

    protected void releaseAction() {
        super.releaseAction();
        this.availableSpecies = null;
        this.selectedSpecies = null;
    }
}

