/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.SoundEngine;
import java.io.Serializable;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class ApplySpeciesFrequencyRafaleAction {
    private static final Log log = LogFactory.getLog(ApplySpeciesFrequencyRafaleAction.class);
    protected final SpeciesFrequencyUI ui;
    protected final SoundEngine soundEngine;

    public ApplySpeciesFrequencyRafaleAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
        this.soundEngine = ui.getHandler().getContext().getSoundEngine();
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.ui.getModel();
        SpeciesFrequencyUIHandler handler = this.ui.getHandler();
        float aroundLengthStep = model.getLengthStep(step.floatValue());
        if (model.isCopyIndividualObservationNothing()) {
            SpeciesFrequencyTableModel tableModel = handler.getTableModel();
            SpeciesFrequencyRowModel row = tableModel.addRafaleRow(aroundLengthStep);
            int rowIndex = tableModel.getRowIndex(row);
            model.recomputeTotalNumber();
            SwingUtilities.invokeLater(() -> this.selectRow(this.ui.getTable(), rowIndex));
        }
        JXTable logsTable = this.ui.getLogsTable();
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)logsTable.getModel());
        SpeciesFrequencyLogRowModel newLogRow = logsTableModel.createNewRow();
        newLogRow.setDate(new Date());
        newLogRow.setLengthStep(step);
        logsTableModel.addNewRow(0, (Serializable)((Object)newLogRow));
        if (model.isAddIndividualObservationOnRafale()) {
            IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)this.ui.getObsTable().getModel());
            IndividualObservationBatchRowModel obsRow = obsTableModel.addRafaleRow(step);
            newLogRow.setObsRow(obsRow);
            int rowIndex = obsTableModel.getRowIndex(obsRow);
            SwingUtilities.invokeLater(() -> {
                model.getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(true);
                try {
                    this.selectRow(this.ui.getObsTable(), rowIndex);
                }
                finally {
                    model.getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(false);
                }
            });
        }
        if (fromIchtyometer) {
            String unit = model.getLengthStepCaracteristicUnit();
            handler.showInformationMessage(I18n.t((String)"tutti.editSpeciesFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep), unit}));
            this.soundEngine.beepOnExternalDeviceDataReception(unit, aroundLengthStep);
        }
    }

    protected void selectRow(JXTable table, int rowIndex) {
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.scrollRowToVisible(rowIndex);
    }
}

