/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingCacheRequest;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowState;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingCodeUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.util.Objects;

public class IndividualObservationToSamplingCacheEngine {
    private final SpeciesFrequencyUIModel speciesFrequencyUIModel;
    private final IndividualObservationUICache individualObservationUICache;
    private final SamplingCodeUICache samplingCodeUICache;

    public IndividualObservationToSamplingCacheEngine(SpeciesFrequencyUIModel speciesFrequencyUIModel) {
        this.speciesFrequencyUIModel = speciesFrequencyUIModel;
        this.individualObservationUICache = speciesFrequencyUIModel.getIndividualObservationUICache();
        this.samplingCodeUICache = speciesFrequencyUIModel.getSamplingCodeUICache();
    }

    public boolean computeSamplingCacheUpdate(IndividualObservationBatchRowState oldState, IndividualObservationBatchRowState newState) {
        IndividualObservationSamplingCacheRequest addIndividualObservation = null;
        IndividualObservationSamplingCacheRequest removeIndividualObservation = null;
        IndividualObservationSamplingCacheRequest addSamplingAction = null;
        IndividualObservationSamplingCacheRequest removeSamplingAction = null;
        IndividualObservationSamplingCacheRequest addSamplingCodeAction = null;
        IndividualObservationSamplingCacheRequest removeSamplingCodeAction = null;
        boolean sizeChanged = !Objects.equals(oldState.getSize(), newState.getSize());
        boolean maturityChanged = !Objects.equals(oldState.getMaturity(), newState.getMaturity());
        boolean genderChanged = !Objects.equals(oldState.getGender(), newState.getGender());
        boolean samplingCodeChanged = !Objects.equals(oldState.getSamplingCode(), newState.getSamplingCode());
        boolean withOldSamplingCode = oldState.withSamplingCode();
        boolean withNewSamplingCode = newState.withSamplingCode();
        if (sizeChanged || maturityChanged || genderChanged) {
            removeIndividualObservation = this.toRequest(oldState);
            addIndividualObservation = this.toRequest(newState);
        } else if (samplingCodeChanged) {
            boolean addSampling;
            boolean removeSampling = withOldSamplingCode && !withNewSamplingCode;
            boolean bl = addSampling = withNewSamplingCode && !withOldSamplingCode;
            if (removeSampling) {
                removeSamplingAction = this.toRequest(oldState);
            } else if (addSampling) {
                addSamplingAction = this.toRequest(newState);
            } else {
                removeSamplingCodeAction = this.toRequest(oldState);
                addSamplingCodeAction = this.toRequest(newState);
            }
        }
        boolean actionDone = false;
        if (removeIndividualObservation != null) {
            this.individualObservationUICache.removeIndividualObservation(removeIndividualObservation);
            actionDone = true;
        }
        if (addIndividualObservation != null) {
            this.individualObservationUICache.addIndividualObservation(addIndividualObservation);
            actionDone = true;
        }
        if (removeSamplingAction != null) {
            this.individualObservationUICache.removeSampling(removeSamplingAction);
            this.samplingCodeUICache.removeSampling(removeSamplingAction);
            actionDone = true;
        }
        if (addSamplingAction != null) {
            this.individualObservationUICache.addSampling(addSamplingAction);
            this.samplingCodeUICache.addSampling(addSamplingAction);
            actionDone = true;
        }
        if (removeSamplingCodeAction != null) {
            this.samplingCodeUICache.removeSampling(removeSamplingCodeAction);
            actionDone = true;
        }
        if (addSamplingCodeAction != null) {
            this.samplingCodeUICache.addSampling(addSamplingCodeAction);
            actionDone = true;
        }
        return actionDone;
    }

    private IndividualObservationSamplingCacheRequest toRequest(IndividualObservationBatchRowState state) {
        return new IndividualObservationSamplingCacheRequest(this.speciesFrequencyUIModel.getFishingOperation(), this.speciesFrequencyUIModel.getBatch().getSpecies(), this.speciesFrequencyUIModel.getLengthStepInMm(state.getSize()), state.getMaturity(), state.getGender(), state.getSamplingCode());
    }
}

