/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SplitSpeciesBatchUIHandler
extends AbstractTuttiTableUIHandler<SplitSpeciesBatchRowModel, SplitSpeciesBatchUIModel, SplitSpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUIHandler.class);
    protected final PropertyChangeListener PROPERTY_CATEGORY_CHANGED_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SplitSpeciesBatchUIModel source = (SplitSpeciesBatchUIModel)evt.getSource();
            source.setSelectedCategory(null);
            List data = (List)evt.getNewValue();
            ((SplitSpeciesBatchUI)SplitSpeciesBatchUIHandler.this.ui).getCategoryComboBox().setModel(new DefaultComboBoxModel<Object>(data.toArray()));
        }
    };
    protected final PropertyChangeListener PROPERTY_SELECTED_CATEGORY_CHANGED_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SplitSpeciesBatchUIModel source = (SplitSpeciesBatchUIModel)evt.getSource();
            source.setSampleWeight(null);
            SampleCategoryModelEntry newValue = (SampleCategoryModelEntry)evt.getNewValue();
            SplitSpeciesBatchUIHandler.this.generateTableModel(newValue);
        }
    };
    protected final ActionListener CATEGORY_ACTION_LISTENER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            ((SplitSpeciesBatchUIModel)SplitSpeciesBatchUIHandler.this.getModel()).setSelectedCategory((SampleCategoryModelEntry)comboBox.getSelectedItem());
        }
    };
    protected final PropertyChangeListener PROPERTY_WEIGHT_CHANGED_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null) {
                ((SplitSpeciesBatchRowModel)((Object)evt.getSource())).setSelected(true);
            }
        }
    };

    public SplitSpeciesBatchUIHandler() {
        super("selected", "categoryValue", "weight");
    }

    public SplitSpeciesBatchTableModel getTableModel() {
        return (SplitSpeciesBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SplitSpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SplitSpeciesBatchRowModel row) {
        return row.isSelected();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SplitSpeciesBatchRowModel> rowMonitor, SplitSpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (row.isValid() && log.isInfoEnabled()) {
                log.info((Object)"Change row that was modified and valid");
            }
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SplitSpeciesBatchRowModel oldRow, int newRowIndex, SplitSpeciesBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        if (newRow != null) {
            this.recomputeRowValidState(newRow);
            this.computeSampleWeight();
        }
    }

    @Override
    protected void onRowModified(int rowIndex, SplitSpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.computeSampleWeight();
    }

    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return ((SplitSpeciesBatchUI)this.ui).getValidator();
    }

    public void beforeInit(SplitSpeciesBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SplitSpeciesBatchUIModel model = new SplitSpeciesBatchUIModel(this.getConfig().getSpeciesWeightUnit(), sampleCategoryModel);
        ui.setContextValue(model);
    }

    public void afterInit(SplitSpeciesBatchUI ui) {
        this.initUI(ui);
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        model.addPropertyChangeListener("category", this.PROPERTY_CATEGORY_CHANGED_LISTENER);
        model.addPropertyChangeListener("selectedCategory", this.PROPERTY_SELECTED_CATEGORY_CHANGED_LISTENER);
        ui.getCategoryComboBox().setRenderer(this.newListCellRender(SampleCategoryModelEntry.class));
        ui.getCategoryComboBox().addActionListener(this.CATEGORY_ACTION_LISTENER);
        this.generateTableModel(null);
        this.initTable(this.getTable());
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        return ((SplitSpeciesBatchUI)this.getUI()).getCategoryComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((SplitSpeciesBatchUI)this.ui).getValidator().setBean(null);
        ((SplitSpeciesBatchUIModel)this.getModel()).setValid(false);
        ((SplitSpeciesBatchUIModel)this.getModel()).setSelectedCategory(null);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    public void editBatch(SpeciesBatchRowModel batch) {
        ArrayList categories = Lists.newArrayList();
        SampleCategoryModelEntry bestSampleCategory = null;
        if (batch != null) {
            SampleCategoryModel sampleCategoryModel = ((SplitSpeciesBatchUIModel)this.getModel()).getSampleCategoryModel();
            categories.addAll(sampleCategoryModel.getCategory());
            SampleCategory lastCategory = batch.getFinestCategory();
            Preconditions.checkNotNull((Object)lastCategory, (Object)"Can't split a species batch with no sample category.");
            int firstOrder = lastCategory.getCategoryDef().getOrder();
            for (Integer sampleCategoryId : sampleCategoryModel.getSamplingOrder()) {
                SampleCategory<?> sampleCategory = batch.getSampleCategoryById(sampleCategoryId);
                int order = sampleCategory.getCategoryDef().getOrder();
                if (order >= firstOrder && !sampleCategory.isValid()) continue;
                categories.remove(sampleCategory.getCategoryDef());
            }
            bestSampleCategory = this.getDataContext().getBestFirstSpeciesSampleCategory((List)categories, batch.getSpecies());
        }
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        ((SplitSpeciesBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        model.setSelectedCategory(bestSampleCategory);
        model.setBatch(batch);
    }

    public void editBatch(SpeciesBatchRowModel batch, int sampleCategoryId) {
        Preconditions.checkNotNull((Object)batch);
        Preconditions.checkNotNull((Object)sampleCategoryId);
        List<SpeciesBatchRowModel> rows = batch.getChildBatch();
        Preconditions.checkNotNull(rows);
        ArrayList categories = Lists.newArrayList();
        SampleCategoryModel sampleCategoryModel = ((SplitSpeciesBatchUIModel)this.getModel()).getSampleCategoryModel();
        SampleCategoryModelEntry selectedCategory = sampleCategoryModel.getCategoryById(Integer.valueOf(sampleCategoryId));
        categories.add(selectedCategory);
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        ((SplitSpeciesBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        model.setSelectedCategory(selectedCategory);
        model.setBatch(batch);
        ImmutableMap rowsByValue = Maps.uniqueIndex(model.getRows(), (Function)new Function<SplitSpeciesBatchRowModel, Serializable>(){

            public Serializable apply(SplitSpeciesBatchRowModel input) {
                return input.getCategoryValue();
            }
        });
        for (SpeciesBatchRowModel row : rows) {
            SampleCategory<?> sampleCategory = row.getSampleCategoryById(sampleCategoryId);
            Serializable categoryValue = sampleCategory.getCategoryValue();
            SplitSpeciesBatchRowModel splitRow = (SplitSpeciesBatchRowModel)((Object)rowsByValue.get(categoryValue));
            splitRow.setWeight(sampleCategory.getCategoryWeight());
            splitRow.setSelected(true);
            splitRow.setEditable(false);
        }
        this.computeSampleWeight();
        this.getTableModel().fireTableDataChanged();
    }

    protected void computeSampleWeight() {
        Float result = null;
        List rows = this.getTableModel().getRows();
        for (SplitSpeciesBatchRowModel row : rows) {
            Float weight;
            if (!row.isSelected() || (weight = row.getWeight()) == null) continue;
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + weight.floatValue());
        }
        ((SplitSpeciesBatchUIModel)this.getModel()).setSampleWeight(result);
    }

    protected void generateTableModel(SampleCategoryModelEntry category) {
        ((SplitSpeciesBatchUIModel)this.getModel()).setRows(null);
        Caracteristic data = null;
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.SELECTED, (JTable)table);
        boolean editableCategoryValue = false;
        log.debug((Object)("category " + category));
        if (category != null) {
            log.debug((Object)("category " + category.getLabel()));
            if (!category.getCaracteristic().isQualitativeValueEmpty()) {
                data = category.getCaracteristic();
                log.debug((Object)("data " + data));
            } else {
                editableCategoryValue = true;
                this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.EDITABLE_CATEGORY_VALUE, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
            }
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + data.sizeQualitativeValue() + " qualitative data to add"));
                }
                this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class), SplitSpeciesBatchTableModel.READ_ONLY_CATEGORY_VALUE);
            }
            this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.WEIGHT, this.getConfig().getSpeciesWeightUnit(), (JTable)table);
        }
        SplitSpeciesBatchTableModel tableModel = new SplitSpeciesBatchTableModel((TableColumnModelExt)columnModel, (SelectedCategoryAble)this.getModel(), editableCategoryValue, ((SplitSpeciesBatchUIModel)this.getModel()).isSplitMode());
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.uninstallTableKeyListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Install new table model " + (Object)((Object)tableModel)));
        }
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableSaveOnRowChangedSelectionListener();
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        ArrayList rows = Lists.newArrayList();
        if (data != null) {
            for (CaracteristicQualitativeValue qualitativeValue : data.getQualitativeValue()) {
                log.debug((Object)("QV: " + qualitativeValue));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add QV: " + qualitativeValue));
                }
                SplitSpeciesBatchRowModel newRow = tableModel.createNewRow();
                newRow.setCategoryValue(qualitativeValue);
                newRow.addPropertyChangeListener("weight", this.PROPERTY_WEIGHT_CHANGED_LISTENER);
                rows.add(newRow);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add " + rows.size() + " rows in table model " + "(can add a first empty row? " + editableCategoryValue + ")."));
        }
        ((SplitSpeciesBatchUIModel)this.getModel()).setRows(rows);
    }
}

