/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.adagio.core.service.technical.sanity.DatabaseSanityService;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.TechnicalPersistenceService;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;
import org.springframework.stereotype.Service;

@Service(value="technicalPersistenceService")
public class TechnicalPersistenceServiceImpl
extends AbstractPersistenceService
implements TechnicalPersistenceService {
    private static final Log log = LogFactory.getLog(TechnicalPersistenceServiceImpl.class);
    @Resource(name="databaseSanityService")
    protected DatabaseSanityService databaseSanityService;
    @Resource(name="cacheService")
    protected CacheService cacheService;
    @Resource(name="databaseSchemaDao")
    protected DatabaseSchemaDao databaseSchemaDao;

    @Override
    public <V> V invoke(Callable<V> call) {
        try {
            V result = call.call();
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException((Throwable)e);
        }
    }

    @Override
    public Version getSchemaVersion() {
        String version;
        try {
            version = this.databaseSchemaDao.getSchemaVersion().getVersion();
        }
        catch (VersionNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not find db version", (Throwable)e);
            }
            version = null;
        }
        return version == null ? null : Versions.valueOf((String)version.toString());
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        org.nuiton.util.version.Version version = this.databaseSchemaDao.getSchemaVersionIfUpdate();
        return Versions.valueOf((String)version.toString());
    }

    @Override
    public <U extends UpdateSchemaContextSupport> void prepareUpdateSchemaContext(U context) {
        context.init(this.getSchemaVersion(), this.getSchemaVersionIfUpdate());
    }

    @Override
    public void updateSchema() {
        try {
            this.databaseSchemaDao.updateSchema();
        }
        catch (DatabaseSchemaUpdateException e) {
            throw new ApplicationTechnicalException(e.getCause());
        }
    }

    @Override
    public void sanityDb() {
        this.databaseSanityService.sanity();
    }

    @Override
    public void clearAllCaches() {
        this.cacheService.clearAllCaches();
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getId());
        Preconditions.checkNotNull((Object)entity.getStatus());
        return StatusCode.TEMPORARY.getValue().equals(entity.getStatus().getId()) && (entity.getIdAsInt() != null && entity.getIdAsInt() < 0 || entity.getId() != null && entity.getId().startsWith("#TEMP\u00bf"));
    }
}

