package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SelectSpeciesUI extends JPanel implements TuttiUI<SelectSpeciesUIModel, SelectSpeciesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SHOW_ALL_SPECIES_SELECTED = "showAllSpecies.selected";
    public static final String BINDING_SHOW_ALL_SPECIES_VISIBLE = "showAllSpecies.visible";
    public static final String BINDING_SPECIES_COMBO_DATA = "speciesCombo.data";
    public static final String BINDING_SPECIES_COMBO_SELECTED_ITEM = "speciesCombo.selectedItem";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS28cRRBuL96H7TwgViJHJNKaOCJGZDYgghAGkvWChY1tLK+DouwBemd6dzv0TDfTNfZYlhE/gZ8Ady5I3DghDpw5cEH8BYQ4cI2o7hnv7NO7Ah/GdlfV11VffVX93Z8kr0Oy/JTGsRNGAXCfOVvVx48/bj5lLrzPtBtyBTIkyc9MjuQaZMHrnmsgtxrbJryShldq0lcyYEFP9No2mddwLJjuMAZAbvZHuFpX6l3zWqyi8Ay1m9Qo1G/+/iv3tffVtzlCYoXZlbCU8qSorJLZbZLjHpAreNMhrQgatDGNkAdtzPeiOasJqvUu9dkX5EtS3CYFRUMEA/LS9CVbDBsfK7xLM4HE1hVzOdN7UkV4+GYrdHgrZD4LHYgAuBNxRx9hIk4EXDg68XbqvbGPNpWyuAUgeV96TABZ+29AOyY6QyuuHNCmYPeALPWRmQBZm/Gc6wZcSHGRhqYEcn9EFPM4kuI0GQ2cdfxscAEsNFA2aF3GButyF/KS7sijqhBpjkCumn7EKdpWrcPcz4eCSitbezRgAjO/0uduTwdydmngMrGOLMkAyGKff3JqPJeyjA6p4B4Flhlvph4hebGvZNSzk+k5E9xMg+TDSJhylhrDI7CPpkT8SwPiN4DW+uza4m8//vHDRq/ir4507RlYVKIKpWIhWCYvJ3I3gqjsULXWIHOJKO003xiRWD01Y3J43wsmPNHTh1R3ECJf/P2nn6999utzJLdB5oWk3gY1/ptkDjohsiCFF6sHD21GF45K+H3e5Aak0GG83cGByt2/F2PhN0YU3r29OffLP4v17x+eFT+DyVwf654RkH9CCjwQPGB24NNZHjngC0qzyJPZzI6aYqIUDu1C0+rASstabtvv6lCZeSCzqBsKZPekbAfV4breJ+87q+UHqanNIDt8OztMBoZ5mfHUDJ4tlnmbwHzs3UmGkRq67uhdSlVwjBrQ/XZADWBG+0yb9TwLYYS6nTXTiusgQT2NI1PfXUu8+atCBiZfpStkHBFF9OevvRXsBMyXAXeBvJ4sqb6d6KB0uAyc/gXg+N2g4iHXHBcHkCcnZRm2Haqo28HmSx89NP4WBg4x9Bv4AJz98wgFq5H5XQkf+AqO74yn1nI715JupKm9KN+iQhtGgMXIz+rUaQOZb8mQtUMZBfjSLJ2U7fDQIzCZ4UJc367WPjLXLYCU4oCrA3vD3emJAXxucA+k/TQiGC+ykT0cWLWTupgf6uIr5ySbbNme7s0nhk3XbN1CYu4SuzwRaZCo25PvtgRd/FRzXwlWtSYgeydTPpUJ1sCTWbPI1fQasxpGT0fvGzOJ18IQr6+eU9vZYzSWWeq6TEGX2VtTYA1y+/I091t2iywwg4LqWzlnBZWX3y0HkRCnw+3Y/1/t+CRNZmJDBt7wSS0xD5SgxxKdyaV3zA4vN3ngYVLvDaHPmO/8FIgls1UPjpV9co5G4yxOxDHHh+cgXEeEfwHZ747Q3QsAAA==";
    private static final Log log = LogFactory.getLog(SelectSpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected final SelectSpeciesUIHandler handler = createHandler();
    protected SelectSpeciesUIModel model;
    protected SelectSpeciesUI selectSpeciesPopup = this;
    protected JCheckBox showAllSpecies;
    protected BeanFilterableComboBox<Species> speciesCombo;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    boolean useSurveyCode;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectSpeciesUI(boolean useSurveyCode, TuttiUI parentUI) {
        this.useSurveyCode = useSurveyCode;
            TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SelectSpeciesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI() {
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__showAllSpecies(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, SelectSpeciesUIModel.PROPERTY_SHOW_ALL_SPECIES);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public SelectSpeciesUIHandler getHandler() {
        return handler;
    }

    public SelectSpeciesUIModel getModel() {
        return model;
    }

    public JCheckBox getShowAllSpecies() {
        return showAllSpecies;
    }

    public BeanFilterableComboBox<Species> getSpeciesCombo() {
        return speciesCombo;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectSpeciesPopup() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.selectSpecies.action.cancel"));
        cancelButton.setToolTipText(t("tutti.selectSpecies.action.cancel.tip"));
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.species.actions.SelectSpeciesCancelAction.class);
    }

    protected SelectSpeciesUIHandler createHandler() {
        return new SelectSpeciesUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectSpeciesUIModel.class));
    }

    protected void createShowAllSpecies() {
        $objectMap.put("showAllSpecies", showAllSpecies = new JCheckBox());
        
        showAllSpecies.setName("showAllSpecies");
        showAllSpecies.setFocusable(false);
        showAllSpecies.setText(t("tutti.selectSpecies.action.showAllSpecies"));
        showAllSpecies.setToolTipText(t("tutti.selectSpecies.action.showAllSpecies.tip"));
        showAllSpecies.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__showAllSpecies"));
    }

    protected void createSpeciesCombo() {
        $objectMap.put("speciesCombo", speciesCombo = new BeanFilterableComboBox<Species>(this));
        
        speciesCombo.setName("speciesCombo");
        speciesCombo.setProperty("selectedSpecies");
        speciesCombo.setShowReset(true);
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.selectSpecies.action.validate"));
        validateButton.setToolTipText(t("tutti.selectSpecies.action.validate.tip"));
        validateButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.species.actions.SelectSpeciesValidateAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectSpeciesPopup();
        // inline complete setup of $Table0
        $Table0.add(speciesCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(showAllSpecies, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        speciesCombo.setBeanType(Species.class);
        speciesCombo.setBean(model);
        showAllSpecies.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectSpecies.action.showAllSpecies.mnemonic"),'Z'));
        showAllSpecies.setForeground( java.awt.Color.BLACK );
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectSpecies.action.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectSpecies.action.validate.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("accept"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("selectSpeciesPopup", selectSpeciesPopup);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesCombo();
        createShowAllSpecies();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of selectSpeciesPopup
        setName("selectSpeciesPopup");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_DATA, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showAllSpecies", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("filteredSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesCombo.setData( model.isShowAllSpecies() ? model.getSpecies() : model.getFilteredSpecies() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showAllSpecies", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("filteredSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesCombo.setSelectedItem(model.getSelectedSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_ALL_SPECIES_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("filteredSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    showAllSpecies.setVisible( org.apache.commons.collections4.CollectionUtils.isNotEmpty(model.getFilteredSpecies()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("filteredSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_ALL_SPECIES_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showAllSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    showAllSpecies.setSelected( model.isShowAllSpecies() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showAllSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateButton.setEnabled(model.getSelectedSpecies() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSpecies", this);
                }
            }
        });
    }

}