package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import javax.swing.JOptionPane;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 3/7/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.15
 */
public class OpenSplitBenthosBatchUIAction extends SimpleActionSupport<BenthosBatchUI> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(OpenSplitBenthosBatchUIAction.class);

    private static final long serialVersionUID = -6540241422935319461L;

    public OpenSplitBenthosBatchUIAction(BenthosBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(BenthosBatchUI ui) {

        JXTable table = ui.getTable();

        // get selected row
        int rowIndex = SwingUtil.getSelectedModelRow(table);

        Preconditions.checkState(rowIndex != -1, "Cant split batch if no batch selected");

        BenthosBatchUIHandler handler = ui.getHandler();
        BenthosBatchTableModel tableModel = handler.getTableModel();

        BenthosBatchRowModel parentBatch = tableModel.getEntry(rowIndex);

        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format(
                    BenthosBatchUIHandler.CONFIRMATION_FORMAT,
                    t("tutti.editBenthosBatch.split.weightNotNull.message"),
                    t("tutti.editBenthosBatch.split.weightNotNull.help"));
            int i = JOptionPane.showConfirmDialog(
                    handler.getTopestUI(),
                    htmlMessage,
                    t("tutti.editBenthosBatch.split.weightNotNull.title"),
                    JOptionPane.OK_CANCEL_OPTION);

            if (i == JOptionPane.OK_OPTION) {
                parentBatch.setWeight(null);

            } else {
                split = false;
            }
        }

        if (split) {
            if (log.isDebugEnabled()) {
                log.debug("Open split batch ui for row [" + rowIndex + ']');
            }

            EditCatchesUI parentUI = ui.getParentContainer(EditCatchesUI.class);
            SplitBenthosBatchUI splitBatchEditor = parentUI.getBenthosTabSplitBatch();

//            parentUI.getHandler().splitBenthosBatch(parentBatch, splitBatchEditor);

            splitBatchEditor.getHandler().editBatch(parentBatch);

            // open split editor
            parentUI.getHandler().setBenthosSelectedCard(EditCatchesUIHandler.SPLIT_BATCH_CARD);

            // update title
            String title = handler.buildReminderLabelTitle(parentBatch.getSpecies(),
                                                           parentBatch,
                                                           parentUI.getBenthosTabFishingOperationReminderLabel().getTitle(),
                                                           t("tutti.splitBenthosBatch.title"));
            parentUI.getBenthosTabSplitBatchReminderLabel().setTitle(title);

        }

    }
}
