package fr.ifremer.tutti.ui.swing.content.protocol.rtp;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class RtpEditorUI extends JDialog implements TuttiUI<RtpEditorUIModel, RtpEditorUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COPY_VALUES_BUTTON_ENABLED = "copyValuesButton.enabled";
    public static final String BINDING_NEXT_ROW_BUTTON_ENABLED = "nextRowButton.enabled";
    public static final String BINDING_PREVIOUS_ROW_BUTTON_ENABLED = "previousRowButton.enabled";
    public static final String BINDING_RTP_FEMALE_AFIELD_NUMBER_VALUE = "rtpFemaleAField.numberValue";
    public static final String BINDING_RTP_FEMALE_BFIELD_NUMBER_VALUE = "rtpFemaleBField.numberValue";
    public static final String BINDING_RTP_MALE_AFIELD_NUMBER_VALUE = "rtpMaleAField.numberValue";
    public static final String BINDING_RTP_MALE_BFIELD_NUMBER_VALUE = "rtpMaleBField.numberValue";
    public static final String BINDING_RTP_UNDEFINED_AFIELD_NUMBER_VALUE = "rtpUndefinedAField.numberValue";
    public static final String BINDING_RTP_UNDEFINED_BFIELD_NUMBER_VALUE = "rtpUndefinedBField.numberValue";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(RtpEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actions;
    protected JXTitledPanel bodyPanel;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JButton copyValuesButton;
    protected Table femaleAPanel;
    protected Table femaleBPanel;
    protected JPanel femalePanel;
    protected final RtpEditorUIHandler handler = createHandler();
    protected JToolBar headerToolBar;
    protected Table maleAPanel;
    protected Table maleBPanel;
    protected JPanel malePanel;
    protected RtpEditorUIModel model;
    protected JButton nextRowButton;
    protected JButton previousRowButton;
    protected RtpEditorUI rtpEditorDialog = this;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpFemaleA",  editorName = "rtpFemaleAField")
    protected NumberEditor rtpFemaleAField;
    protected JLabel rtpFemaleALabel;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpFemaleB",  editorName = "rtpFemaleBField")
    protected NumberEditor rtpFemaleBField;
    protected JLabel rtpFemaleBLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpMaleA",  editorName = "rtpMaleAField")
    protected NumberEditor rtpMaleAField;
    protected JLabel rtpMaleALabel;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpMaleB",  editorName = "rtpMaleBField")
    protected NumberEditor rtpMaleBField;
    protected JLabel rtpMaleBLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpUndefinedA",  editorName = "rtpUndefinedAField")
    protected NumberEditor rtpUndefinedAField;
    protected JLabel rtpUndefinedALabel;
    @ValidatorField( validatorId = "validator",  propertyName = "rtpUndefinedB",  editorName = "rtpUndefinedBField")
    protected NumberEditor rtpUndefinedBField;
    protected JLabel rtpUndefinedBLabel;
    protected JButton saveButton;
    protected Table undefinedAPanel;
    protected Table undefinedBPanel;
    protected JPanel undefinedPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<RtpEditorUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void setBean(EditProtocolSpeciesTableModel tableModel, RowSorter rowSorter, int row) {
        handler.setBean(tableModel, rowSorter, row);
    }
    
    public void openEditor() { handler.openEditor(); }
    
    public void closeEditor() { handler.closeEditor(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RtpEditorUI(TuttiUI parentUI) {
        super(parentUI.getHandler().getContext().getMainUI());
            TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public RtpEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI() {
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RtpEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RtpEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActions() {
        return actions;
    }

    public JXTitledPanel getBodyPanel() {
        return bodyPanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getCopyValuesButton() {
        return copyValuesButton;
    }

    public Table getFemaleAPanel() {
        return femaleAPanel;
    }

    public Table getFemaleBPanel() {
        return femaleBPanel;
    }

    public JPanel getFemalePanel() {
        return femalePanel;
    }

    public RtpEditorUIHandler getHandler() {
        return handler;
    }

    public JToolBar getHeaderToolBar() {
        return headerToolBar;
    }

    public Table getMaleAPanel() {
        return maleAPanel;
    }

    public Table getMaleBPanel() {
        return maleBPanel;
    }

    public JPanel getMalePanel() {
        return malePanel;
    }

    public RtpEditorUIModel getModel() {
        return model;
    }

    public JButton getNextRowButton() {
        return nextRowButton;
    }

    public JButton getPreviousRowButton() {
        return previousRowButton;
    }

    public NumberEditor getRtpFemaleAField() {
        return rtpFemaleAField;
    }

    public JLabel getRtpFemaleALabel() {
        return rtpFemaleALabel;
    }

    public NumberEditor getRtpFemaleBField() {
        return rtpFemaleBField;
    }

    public JLabel getRtpFemaleBLabel() {
        return rtpFemaleBLabel;
    }

    public NumberEditor getRtpMaleAField() {
        return rtpMaleAField;
    }

    public JLabel getRtpMaleALabel() {
        return rtpMaleALabel;
    }

    public NumberEditor getRtpMaleBField() {
        return rtpMaleBField;
    }

    public JLabel getRtpMaleBLabel() {
        return rtpMaleBLabel;
    }

    public NumberEditor getRtpUndefinedAField() {
        return rtpUndefinedAField;
    }

    public JLabel getRtpUndefinedALabel() {
        return rtpUndefinedALabel;
    }

    public NumberEditor getRtpUndefinedBField() {
        return rtpUndefinedBField;
    }

    public JLabel getRtpUndefinedBLabel() {
        return rtpUndefinedBLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public Table getUndefinedAPanel() {
        return undefinedAPanel;
    }

    public Table getUndefinedBPanel() {
        return undefinedBPanel;
    }

    public JPanel getUndefinedPanel() {
        return undefinedPanel;
    }

    public SwingValidator<RtpEditorUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(closeButton);
        actions.add(saveButton);
    }

    protected void addChildrenToBodyPanel() {
        if (!allComponentsCreated) {
            return;
        }
        bodyPanel.add($JPanel0);
    }

    protected void addChildrenToFemaleAPanel() {
        if (!allComponentsCreated) {
            return;
        }
        femaleAPanel.add(rtpFemaleALabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        femaleAPanel.add(SwingUtil.boxComponentWithJxLayer(rtpFemaleAField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFemaleBPanel() {
        if (!allComponentsCreated) {
            return;
        }
        femaleBPanel.add(rtpFemaleBLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        femaleBPanel.add(SwingUtil.boxComponentWithJxLayer(rtpFemaleBField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFemalePanel() {
        if (!allComponentsCreated) {
            return;
        }
        femalePanel.add(femaleAPanel);
        femalePanel.add(femaleBPanel);
    }

    protected void addChildrenToHeaderToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        headerToolBar.add(previousRowButton);
        headerToolBar.add(nextRowButton);
    }

    protected void addChildrenToMaleAPanel() {
        if (!allComponentsCreated) {
            return;
        }
        maleAPanel.add(rtpMaleALabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        maleAPanel.add(SwingUtil.boxComponentWithJxLayer(rtpMaleAField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMaleBPanel() {
        if (!allComponentsCreated) {
            return;
        }
        maleBPanel.add(rtpMaleBLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        maleBPanel.add(SwingUtil.boxComponentWithJxLayer(rtpMaleBField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMalePanel() {
        if (!allComponentsCreated) {
            return;
        }
        malePanel.add($JPanel1);
        malePanel.add(copyValuesButton);
    }

    protected void addChildrenToRtpEditorDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(headerToolBar);
        add(bodyPanel, BorderLayout.NORTH);
        add(actions, BorderLayout.SOUTH);
    }

    protected void addChildrenToUndefinedAPanel() {
        if (!allComponentsCreated) {
            return;
        }
        undefinedAPanel.add(rtpUndefinedALabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        undefinedAPanel.add(SwingUtil.boxComponentWithJxLayer(rtpUndefinedAField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToUndefinedBPanel() {
        if (!allComponentsCreated) {
            return;
        }
        undefinedBPanel.add(rtpUndefinedBLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        undefinedBPanel.add(SwingUtil.boxComponentWithJxLayer(rtpUndefinedBField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToUndefinedPanel() {
        if (!allComponentsCreated) {
            return;
        }
        undefinedPanel.add(undefinedAPanel);
        undefinedPanel.add(undefinedBPanel);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JPanel());
        
        actions.setName("actions");
        actions.setLayout(new GridLayout(1, 2));
    }

    protected void createBodyPanel() {
        $objectMap.put("bodyPanel", bodyPanel = new JXTitledPanel());
        
        bodyPanel.setName("bodyPanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editRtp.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editRtp.action.close"));
        closeButton.setToolTipText(t("tutti.editRtp.action.close.tip"));
        closeButton.putClientProperty("help", "tutti.editRtp.action.close.help");
        closeButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.rtp.actions.CloseRtpAction.class);
    }

    protected void createCopyValuesButton() {
        $objectMap.put("copyValuesButton", copyValuesButton = new JButton());
        
        copyValuesButton.setName("copyValuesButton");
        copyValuesButton.setText(t("tutti.editRtp.action.copyValues"));
        copyValuesButton.setToolTipText(t("tutti.editRtp.action.copyValues.tip"));
        copyValuesButton.putClientProperty("help", "tutti.editRtp.action.copyValues.help");
        copyValuesButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.rtp.actions.CopyMaleRtpAction.class);
    }

    protected void createFemaleAPanel() {
        $objectMap.put("femaleAPanel", femaleAPanel = new Table());
        
        femaleAPanel.setName("femaleAPanel");
    }

    protected void createFemaleBPanel() {
        $objectMap.put("femaleBPanel", femaleBPanel = new Table());
        
        femaleBPanel.setName("femaleBPanel");
    }

    protected void createFemalePanel() {
        $objectMap.put("femalePanel", femalePanel = new JPanel());
        
        femalePanel.setName("femalePanel");
        femalePanel.setLayout(new GridLayout(1, 2));
    }

    protected RtpEditorUIHandler createHandler() {
        return new RtpEditorUIHandler();
    }

    protected void createHeaderToolBar() {
        $objectMap.put("headerToolBar", headerToolBar = new JToolBar());
        
        headerToolBar.setName("headerToolBar");
        headerToolBar.setBorderPainted(false);
        headerToolBar.setOpaque(true);
        headerToolBar.setFloatable(false);
    }

    protected void createMaleAPanel() {
        $objectMap.put("maleAPanel", maleAPanel = new Table());
        
        maleAPanel.setName("maleAPanel");
    }

    protected void createMaleBPanel() {
        $objectMap.put("maleBPanel", maleBPanel = new Table());
        
        maleBPanel.setName("maleBPanel");
    }

    protected void createMalePanel() {
        $objectMap.put("malePanel", malePanel = new JPanel());
        
        malePanel.setName("malePanel");
        malePanel.setLayout(new GridLayout(2, 1));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(RtpEditorUIModel.class));
    }

    protected void createNextRowButton() {
        $objectMap.put("nextRowButton", nextRowButton = new JButton());
        
        nextRowButton.setName("nextRowButton");
        nextRowButton.setToolTipText(t("tutti.editRtp.action.next.tip"));
        nextRowButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.rtp.actions.EditNextRowAction.class);
    }

    protected void createPreviousRowButton() {
        $objectMap.put("previousRowButton", previousRowButton = new JButton());
        
        previousRowButton.setName("previousRowButton");
        previousRowButton.setToolTipText(t("tutti.editRtp.action.previous.tip"));
        previousRowButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.rtp.actions.EditPreviousRowAction.class);
    }

    protected void createRtpFemaleAField() {
        $objectMap.put("rtpFemaleAField", rtpFemaleAField = new NumberEditor());
        
        rtpFemaleAField.setName("rtpFemaleAField");
        rtpFemaleAField.setShowReset(true);
        rtpFemaleAField.putClientProperty("help", "tutti.editRtp.field.rtpFemaleA.help");
        rtpFemaleAField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpFemaleALabel() {
        $objectMap.put("rtpFemaleALabel", rtpFemaleALabel = new JLabel());
        
        rtpFemaleALabel.setName("rtpFemaleALabel");
        rtpFemaleALabel.setText(t("tutti.editRtp.field.rtpFemaleA"));
        rtpFemaleALabel.setToolTipText(t("tutti.editRtp.field.rtpFemaleA.tip"));
        rtpFemaleALabel.putClientProperty("help", "tutti.editRtp.field.rtpFemaleA.help");
    }

    protected void createRtpFemaleBField() {
        $objectMap.put("rtpFemaleBField", rtpFemaleBField = new NumberEditor());
        
        rtpFemaleBField.setName("rtpFemaleBField");
        rtpFemaleBField.setShowReset(true);
        rtpFemaleBField.putClientProperty("help", "tutti.editRtp.field.rtpFemaleB.help");
        rtpFemaleBField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpFemaleBLabel() {
        $objectMap.put("rtpFemaleBLabel", rtpFemaleBLabel = new JLabel());
        
        rtpFemaleBLabel.setName("rtpFemaleBLabel");
        rtpFemaleBLabel.setText(t("tutti.editRtp.field.rtpFemaleB"));
        rtpFemaleBLabel.setToolTipText(t("tutti.editRtp.field.rtpFemaleB.tip"));
        rtpFemaleBLabel.putClientProperty("help", "tutti.editRtp.field.rtpFemaleB.help");
    }

    protected void createRtpMaleAField() {
        $objectMap.put("rtpMaleAField", rtpMaleAField = new NumberEditor());
        
        rtpMaleAField.setName("rtpMaleAField");
        rtpMaleAField.setShowReset(true);
        rtpMaleAField.putClientProperty("help", "tutti.editRtp.field.rtpMaleA.help");
        rtpMaleAField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpMaleALabel() {
        $objectMap.put("rtpMaleALabel", rtpMaleALabel = new JLabel());
        
        rtpMaleALabel.setName("rtpMaleALabel");
        rtpMaleALabel.setText(t("tutti.editRtp.field.rtpMaleA"));
        rtpMaleALabel.setToolTipText(t("tutti.editRtp.field.rtpMaleA.tip"));
        rtpMaleALabel.putClientProperty("help", "tutti.editRtp.field.rtpMaleA.help");
    }

    protected void createRtpMaleBField() {
        $objectMap.put("rtpMaleBField", rtpMaleBField = new NumberEditor());
        
        rtpMaleBField.setName("rtpMaleBField");
        rtpMaleBField.setShowReset(true);
        rtpMaleBField.putClientProperty("help", "tutti.editRtp.field.rtpMaleB.help");
        rtpMaleBField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpMaleBLabel() {
        $objectMap.put("rtpMaleBLabel", rtpMaleBLabel = new JLabel());
        
        rtpMaleBLabel.setName("rtpMaleBLabel");
        rtpMaleBLabel.setText(t("tutti.editRtp.field.rtpMaleB"));
        rtpMaleBLabel.setToolTipText(t("tutti.editRtp.field.rtpMaleB.tip"));
        rtpMaleBLabel.putClientProperty("help", "tutti.editRtp.field.rtpMaleB.help");
    }

    protected void createRtpUndefinedAField() {
        $objectMap.put("rtpUndefinedAField", rtpUndefinedAField = new NumberEditor());
        
        rtpUndefinedAField.setName("rtpUndefinedAField");
        rtpUndefinedAField.setShowReset(true);
        rtpUndefinedAField.putClientProperty("help", "tutti.editRtp.field.rtpUndefinedA.help");
        rtpUndefinedAField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpUndefinedALabel() {
        $objectMap.put("rtpUndefinedALabel", rtpUndefinedALabel = new JLabel());
        
        rtpUndefinedALabel.setName("rtpUndefinedALabel");
        rtpUndefinedALabel.setText(t("tutti.editRtp.field.rtpUndefinedA"));
        rtpUndefinedALabel.setToolTipText(t("tutti.editRtp.field.rtpUndefinedA.tip"));
        rtpUndefinedALabel.putClientProperty("help", "tutti.editRtp.field.rtpUndefinedA.help");
    }

    protected void createRtpUndefinedBField() {
        $objectMap.put("rtpUndefinedBField", rtpUndefinedBField = new NumberEditor());
        
        rtpUndefinedBField.setName("rtpUndefinedBField");
        rtpUndefinedBField.setShowReset(true);
        rtpUndefinedBField.putClientProperty("help", "tutti.editRtp.field.rtpUndefinedB.help");
        rtpUndefinedBField.putClientProperty("selectOnFocus", true);
    }

    protected void createRtpUndefinedBLabel() {
        $objectMap.put("rtpUndefinedBLabel", rtpUndefinedBLabel = new JLabel());
        
        rtpUndefinedBLabel.setName("rtpUndefinedBLabel");
        rtpUndefinedBLabel.setText(t("tutti.editRtp.field.rtpUndefinedB"));
        rtpUndefinedBLabel.setToolTipText(t("tutti.editRtp.field.rtpUndefinedB.tip"));
        rtpUndefinedBLabel.putClientProperty("help", "tutti.editRtp.field.rtpUndefinedB.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editRtp.action.save"));
        saveButton.setToolTipText(t("tutti.editRtp.action.save.tip"));
        saveButton.putClientProperty("help", "tutti.editRtp.action.save.help");
        saveButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.rtp.actions.SaveRtpAction.class);
    }

    protected void createUndefinedAPanel() {
        $objectMap.put("undefinedAPanel", undefinedAPanel = new Table());
        
        undefinedAPanel.setName("undefinedAPanel");
    }

    protected void createUndefinedBPanel() {
        $objectMap.put("undefinedBPanel", undefinedBPanel = new Table());
        
        undefinedBPanel.setName("undefinedBPanel");
    }

    protected void createUndefinedPanel() {
        $objectMap.put("undefinedPanel", undefinedPanel = new JPanel());
        
        undefinedPanel.setName("undefinedPanel");
        undefinedPanel.setLayout(new GridLayout(1, 2));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(RtpEditorUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToRtpEditorDialog();
        addChildrenToValidator();
        addChildrenToHeaderToolBar();
        addChildrenToBodyPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(malePanel);
        $JPanel0.add(femalePanel);
        $JPanel0.add(undefinedPanel);
        addChildrenToMalePanel();
        // inline complete setup of $JPanel1
        $JPanel1.add(maleAPanel);
        $JPanel1.add(maleBPanel);
        addChildrenToMaleAPanel();
        addChildrenToMaleBPanel();
        addChildrenToFemalePanel();
        addChildrenToFemaleAPanel();
        addChildrenToFemaleBPanel();
        addChildrenToUndefinedPanel();
        addChildrenToUndefinedAPanel();
        addChildrenToUndefinedBPanel();
        addChildrenToActions();
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 60 property setters
        malePanel.setBorder(new TitledBorder(t("tutti.editRtp.malePanel")));
        femalePanel.setBorder(new TitledBorder(t("tutti.editRtp.femalePanel")));
        undefinedPanel.setBorder(new TitledBorder(t("tutti.editRtp.undefinedPanel")));
        previousRowButton.setIcon(SwingUtil.createActionIcon("previous"));
        nextRowButton.setIcon(SwingUtil.createActionIcon("next"));
        rtpMaleALabel.setLabelFor(rtpMaleAField);
        rtpMaleAField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpMaleAField.setNumberType(Double.class);
        rtpMaleAField.setNumberPattern(DECIMAL9_PATTERN);
        rtpMaleAField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpMaleAField.setProperty(RtpEditorUIModel.PROPERTY_RTP_MALE_A);
        rtpMaleAField.setBean(model);
        rtpMaleBLabel.setLabelFor(rtpMaleBField);
        rtpMaleBField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpMaleBField.setNumberType(Float.class);
        rtpMaleBField.setNumberPattern(DECIMAL4_PATTERN);
        rtpMaleBField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpMaleBField.setProperty(RtpEditorUIModel.PROPERTY_RTP_MALE_B);
        rtpMaleBField.setBean(model);
        copyValuesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editRtp.action.copyValues.mnemonic"),'Z'));
        copyValuesButton.setIcon(SwingUtil.createActionIcon("copy"));
        rtpFemaleALabel.setLabelFor(rtpFemaleAField);
        rtpFemaleAField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpFemaleAField.setNumberType(Double.class);
        rtpFemaleAField.setNumberPattern(DECIMAL9_PATTERN);
        rtpFemaleAField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpFemaleAField.setProperty(RtpEditorUIModel.PROPERTY_RTP_FEMALE_A);
        rtpFemaleAField.setBean(model);
        rtpFemaleBLabel.setLabelFor(rtpFemaleBField);
        rtpFemaleBField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpFemaleBField.setNumberType(Float.class);
        rtpFemaleBField.setNumberPattern(DECIMAL4_PATTERN);
        rtpFemaleBField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpFemaleBField.setProperty(RtpEditorUIModel.PROPERTY_RTP_FEMALE_B);
        rtpFemaleBField.setBean(model);
        rtpUndefinedALabel.setLabelFor(rtpUndefinedAField);
        rtpUndefinedAField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpUndefinedAField.setNumberType(Double.class);
        rtpUndefinedAField.setNumberPattern(DECIMAL9_PATTERN);
        rtpUndefinedAField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpUndefinedAField.setProperty(RtpEditorUIModel.PROPERTY_RTP_UNDEFINED_A);
        rtpUndefinedAField.setBean(model);
        rtpUndefinedBLabel.setLabelFor(rtpUndefinedBField);
        rtpUndefinedBField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rtpUndefinedBField.setNumberType(Float.class);
        rtpUndefinedBField.setNumberPattern(DECIMAL4_PATTERN);
        rtpUndefinedBField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rtpUndefinedBField.setProperty(RtpEditorUIModel.PROPERTY_RTP_UNDEFINED_B);
        rtpUndefinedBField.setBean(model);
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editRtp.action.close.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("close"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editRtp.action.save.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        rtpEditorDialog.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("rtpEditorDialog", rtpEditorDialog);
        createModel();
        createBroker();
        createValidator();
        createHeaderToolBar();
        createPreviousRowButton();
        createNextRowButton();
        createBodyPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(3, 1));
        createMalePanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 2));
        createMaleAPanel();
        createRtpMaleALabel();
        createRtpMaleAField();
        createMaleBPanel();
        createRtpMaleBLabel();
        createRtpMaleBField();
        createCopyValuesButton();
        createFemalePanel();
        createFemaleAPanel();
        createRtpFemaleALabel();
        createRtpFemaleAField();
        createFemaleBPanel();
        createRtpFemaleBLabel();
        createRtpFemaleBField();
        createUndefinedPanel();
        createUndefinedAPanel();
        createRtpUndefinedALabel();
        createRtpUndefinedAField();
        createUndefinedBPanel();
        createRtpUndefinedBLabel();
        createRtpUndefinedBField();
        createActions();
        createCloseButton();
        createSaveButton();
        // inline creation of rtpEditorDialog
        setName("rtpEditorDialog");
        rtpEditorDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setUndecorated(true);
        setAlwaysOnTop(true);
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREVIOUS_ROW_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("firstRow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    previousRowButton.setEnabled(!model.isFirstRow());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("firstRow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_ROW_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastRow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    nextRowButton.setEnabled(!model.isLastRow());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastRow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_MALE_AFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpMaleA", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpMaleAField.setNumberValue(model.getRtpMaleA());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpMaleA", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_MALE_BFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpMaleB", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpMaleBField.setNumberValue(model.getRtpMaleB());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpMaleB", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COPY_VALUES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpMaleA", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rtpMaleB", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    copyValuesButton.setEnabled(model.getRtpMaleA() != null && model.getRtpMaleB() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpMaleA", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rtpMaleB", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_FEMALE_AFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpFemaleA", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpFemaleAField.setNumberValue(model.getRtpFemaleA());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpFemaleA", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_FEMALE_BFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpFemaleB", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpFemaleBField.setNumberValue(model.getRtpFemaleB());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpFemaleB", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_UNDEFINED_AFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpUndefinedA", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpUndefinedAField.setNumberValue(model.getRtpUndefinedA());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpUndefinedA", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RTP_UNDEFINED_BFIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rtpUndefinedB", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rtpUndefinedBField.setNumberValue(model.getRtpUndefinedB());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rtpUndefinedB", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}