package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class CreateSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE = "batchCountField.numberValue";
    public static final String BINDING_BATCH_COUNT_LABEL_BACKGROUND = "batchCountLabel.background";
    public static final String BINDING_BATCH_COUNT_LABEL_FONT_WEIGHT = "batchCountLabel.font-weight";
    public static final String BINDING_BATCH_COUNT_LABEL_FOREGROUND = "batchCountLabel.foreground";
    public static final String BINDING_BATCH_COUNT_LABEL_OPAQUE = "batchCountLabel.opaque";
    public static final String BINDING_BATCH_SAMPLE_CATEGORY_WEIGHT_FIELD_NUMBER_VALUE = "batchSampleCategoryWeightField.numberValue";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE = "batchWeightField.numberValue";
    public static final String BINDING_CATEGORY_COMBO_BOX_DATA = "categoryComboBox.data";
    public static final String BINDING_CATEGORY_COMBO_BOX_ENABLED = "categoryComboBox.enabled";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_CATEGORY_PANEL_VISIBLE = "categoryPanel.visible";
    public static final String BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sampleCategoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SAVE_AND_FREQUENCIES_BUTTON_BACKGROUND = "saveAndFrequenciesButton.background";
    public static final String BINDING_SAVE_AND_FREQUENCIES_BUTTON_ENABLED = "saveAndFrequenciesButton.enabled";
    public static final String BINDING_SAVE_AND_FREQUENCIES_BUTTON_FONT_WEIGHT = "saveAndFrequenciesButton.font-weight";
    public static final String BINDING_SAVE_AND_FREQUENCIES_BUTTON_FOREGROUND = "saveAndFrequenciesButton.foreground";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";
    public static final String BINDING_SPECIES_FREQUENCY_MEASUREMENT_LABEL_TEXT = "speciesFrequencyMeasurementLabel.text";
    public static final String BINDING_SPECIES_FREQUENCY_MEASUREMENT_LABEL_VISIBLE = "speciesFrequencyMeasurementLabel.visible";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchCount",  editorName = "batchCountField")
    protected NumberEditor batchCountField;
    protected JLabel batchCountLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchSampleCategoryWeight",  editorName = "batchSampleCategoryWeightField")
    protected NumberEditor batchSampleCategoryWeightField;
    protected JLabel batchSampleCategoryWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanFilterableComboBox<SampleCategoryModelEntry> categoryComboBox;
    protected Table categoryConfigurationPanel;
    protected JLabel categoryLabel;
    protected JPanel categoryPanel;
    protected Table configurationPanel;
    protected CreateSpeciesBatchUI createSpeciesBatchTopPanel = this;
    protected final CreateSpeciesBatchUIHandler handler = createHandler();
    protected CreateSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleCategory",  editorName = "sampleCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sampleCategoryComboBox;
    protected JLabel sampleCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    protected JButton saveAndFrequenciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesFrequencyMeasurementLabel;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateSpeciesBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI() {
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchCountField() {
        return batchCountField;
    }

    public JLabel getBatchCountLabel() {
        return batchCountLabel;
    }

    public NumberEditor getBatchSampleCategoryWeightField() {
        return batchSampleCategoryWeightField;
    }

    public JLabel getBatchSampleCategoryWeightLabel() {
        return batchSampleCategoryWeightLabel;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanFilterableComboBox<SampleCategoryModelEntry> getCategoryComboBox() {
        return categoryComboBox;
    }

    public Table getCategoryConfigurationPanel() {
        return categoryConfigurationPanel;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryPanel() {
        return categoryPanel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public CreateSpeciesBatchUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSampleCategoryComboBox() {
        return sampleCategoryComboBox;
    }

    public JLabel getSampleCategoryLabel() {
        return sampleCategoryLabel;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public JButton getSaveAndFrequenciesButton() {
        return saveAndFrequenciesButton;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesFrequencyMeasurementLabel() {
        return speciesFrequencyMeasurementLabel;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryConfigurationPanel.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(categoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCategoryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryPanel.add(categoryConfigurationPanel, BorderLayout.NORTH);
        categoryPanel.add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesFrequencyMeasurementLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleCategoryLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCategoryComboBox), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchSampleCategoryWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchSampleCategoryWeightField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchCountLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchCountField), new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(categoryPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setFocusable(false);
        addSpeciesButton.setText(t("tutti.createSpeciesBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(t("tutti.createSpeciesBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createSpeciesBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.SelectSpeciesForSpeciesBatchAction.class);
    }

    protected void createBatchCountField() {
        $objectMap.put("batchCountField", batchCountField = new NumberEditor(this));
        
        batchCountField.setName("batchCountField");
        batchCountField.setProperty("batchCount");
        batchCountField.setShowReset(true);
        batchCountField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchCountLabel() {
        $objectMap.put("batchCountLabel", batchCountLabel = new JLabel());
        
        batchCountLabel.setName("batchCountLabel");
        batchCountLabel.setText(t("tutti.createSpeciesBatch.field.batchCount"));
        batchCountLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchCount.tip"));
        batchCountLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchSampleCategoryWeightField() {
        $objectMap.put("batchSampleCategoryWeightField", batchSampleCategoryWeightField = new NumberEditor(this));
        
        batchSampleCategoryWeightField.setName("batchSampleCategoryWeightField");
        batchSampleCategoryWeightField.setProperty("batchSampleCategoryWeight");
        batchSampleCategoryWeightField.setShowReset(true);
        batchSampleCategoryWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchSampleCategoryWeight.help");
    }

    protected void createBatchSampleCategoryWeightLabel() {
        $objectMap.put("batchSampleCategoryWeightLabel", batchSampleCategoryWeightLabel = new JLabel());
        
        batchSampleCategoryWeightLabel.setName("batchSampleCategoryWeightLabel");
        batchSampleCategoryWeightLabel.setText(t("tutti.createSpeciesBatch.field.batchSampleCategoryWeight"));
        batchSampleCategoryWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchSampleCategoryWeight.tip"));
        batchSampleCategoryWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchSampleCategoryWeight.help");
        batchSampleCategoryWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setShowReset(true);
        batchWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.createSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createSpeciesBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.createSpeciesBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchCancelAction.class);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanFilterableComboBox<SampleCategoryModelEntry>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setShowDecorator(false);
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setSortable(false);
        categoryComboBox.setShowReset(false);
        categoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryConfigurationPanel() {
        $objectMap.put("categoryConfigurationPanel", categoryConfigurationPanel = new Table());
        
        categoryConfigurationPanel.setName("categoryConfigurationPanel");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.createSpeciesBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryPanel() {
        $objectMap.put("categoryPanel", categoryPanel = new JPanel());
        
        categoryPanel.setName("categoryPanel");
        categoryPanel.setLayout(new BorderLayout());
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateSpeciesBatchUIHandler createHandler() {
        return new CreateSpeciesBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateSpeciesBatchUIModel.class));
    }

    protected void createSampleCategoryComboBox() {
        $objectMap.put("sampleCategoryComboBox", sampleCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sampleCategoryComboBox.setName("sampleCategoryComboBox");
        sampleCategoryComboBox.setProperty("sampleCategory");
        sampleCategoryComboBox.setShowReset(true);
        sampleCategoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleCategoryLabel() {
        $objectMap.put("sampleCategoryLabel", sampleCategoryLabel = new JLabel());
        
        sampleCategoryLabel.setName("sampleCategoryLabel");
        sampleCategoryLabel.setText(t("tutti.createSpeciesBatch.field.sampleCategory"));
        sampleCategoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleCategory.tip"));
        sampleCategoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.createSpeciesBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createSpeciesBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndClose.tip"));
        saveAndCloseButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndClose.help");
        saveAndCloseButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchAndCloseAction.class);
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createSpeciesBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndContinue.help");
        saveAndContinueButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchAndContinueAction.class);
    }

    protected void createSaveAndFrequenciesButton() {
        $objectMap.put("saveAndFrequenciesButton", saveAndFrequenciesButton = new JButton());
        
        saveAndFrequenciesButton.setName("saveAndFrequenciesButton");
        saveAndFrequenciesButton.setText(t("tutti.createSpeciesBatch.action.saveAndFrequencies"));
        saveAndFrequenciesButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndFrequencies.tip"));
        saveAndFrequenciesButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndFrequencies.help");
        saveAndFrequenciesButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchAndFrequenciesAction.class);
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
        speciesComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createSpeciesFrequencyMeasurementLabel() {
        $objectMap.put("speciesFrequencyMeasurementLabel", speciesFrequencyMeasurementLabel = new JLabel());
        
        speciesFrequencyMeasurementLabel.setName("speciesFrequencyMeasurementLabel");
        speciesFrequencyMeasurementLabel.setOpaque(true);
        if (speciesFrequencyMeasurementLabel.getFont() != null) {
            speciesFrequencyMeasurementLabel.setFont(speciesFrequencyMeasurementLabel.getFont().deriveFont(speciesFrequencyMeasurementLabel.getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(t("tutti.createSpeciesBatch.field.species"));
        speciesLabel.setToolTipText(t("tutti.createSpeciesBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToCategoryPanel();
        addChildrenToCategoryConfigurationPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        $JPanel0.add(saveAndFrequenciesButton);
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 44 property setters
        speciesComboBox.setBeanType(Species.class);
        sampleCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        categoryComboBox.setBeanType(SampleCategoryModelEntry.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.addSpecies.mnemonic"),'Z'));
        speciesFrequencyMeasurementLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        speciesFrequencyMeasurementLabel.setBackground( handler.getConfig().getColorHighlightInfoBackground() );
        speciesFrequencyMeasurementLabel.setForeground( handler.getConfig().getColorHighlightInfoForeground() );
        sampleCategoryLabel.setLabelFor(sampleCategoryComboBox);
        sampleCategoryComboBox.setBean(model);
        batchSampleCategoryWeightLabel.setLabelFor(batchSampleCategoryWeightField);
        batchSampleCategoryWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchSampleCategoryWeightField.setNumberType(Float.class);
        batchSampleCategoryWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchSampleCategoryWeightField.setBean(model);
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setNumberType(Float.class);
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchWeightField.setBean(model);
        batchCountLabel.setLabelFor(batchCountField);
        batchCountField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchCountField.setNumberType(Integer.class);
        batchCountField.setNumberPattern(INT_6_DIGITS_PATTERN);
        batchCountField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchCountField.setBean(model);
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionBackground(null);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndClose.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndFrequenciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndFrequencies.mnemonic"),'Z'));
        saveAndFrequenciesButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createSpeciesBatchTopPanel, "tutti.createSpeciesBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, speciesComboBox, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createSpeciesBatch.action.addSpecies.help");
        registerHelpId(_broker, sampleCategoryLabel, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, sampleCategoryComboBox, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, batchSampleCategoryWeightLabel, "tutti.createSpeciesBatch.field.batchSampleCategoryWeight.help");
        registerHelpId(_broker, batchSampleCategoryWeightField, "tutti.createSpeciesBatch.field.batchSampleCategoryWeight.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchWeightField, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchCountLabel, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, batchCountField, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, categoryLabel, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, categoryComboBox, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.createSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createSpeciesBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createSpeciesBatch.action.saveAndClose.help");
        registerHelpId(_broker, saveAndFrequenciesButton, "tutti.createSpeciesBatch.action.saveAndFrequencies.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createSpeciesBatchTopPanel", createSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createSpeciesFrequencyMeasurementLabel();
        createSampleCategoryLabel();
        createSampleCategoryComboBox();
        createBatchSampleCategoryWeightLabel();
        createBatchSampleCategoryWeightField();
        createBatchWeightLabel();
        createBatchWeightField();
        createBatchCountLabel();
        createBatchCountField();
        createCategoryPanel();
        createCategoryConfigurationPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createCategoryLabel();
        createCategoryComboBox();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight($JPanel0,50);
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        createSaveAndFrequenciesButton();
        // inline creation of createSpeciesBatchTopPanel
        setName("createSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        createSpeciesBatchTopPanel.putClientProperty("help", "tutti.createSpeciesBatch.help");
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_FREQUENCY_MEASUREMENT_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesFrequencyMeasurementLabel.setVisible( model.getSpeciesProtocolFrequencyMode() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_FREQUENCY_MEASUREMENT_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getSpeciesProtocolFrequencyMode() != null) {
                    speciesFrequencyMeasurementLabel.setText(t( model.getSpeciesProtocolFrequencyMode().toString() ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCategoryComboBox.setSelectedItem(model.getSampleCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_SAMPLE_CATEGORY_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchSampleCategoryWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchSampleCategoryWeightField.setNumberValue(model.getBatchSampleCategoryWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchSampleCategoryWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setNumberValue(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_LABEL_OPAQUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountLabel.setOpaque(CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.COUNT == model.getSpeciesProtocolFrequencyMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_LABEL_FONT_WEIGHT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    if (batchCountLabel.getFont() != null) {
                        if (( CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.COUNT == model.getSpeciesProtocolFrequencyMode() ? "bold" : "normal" ).equals("bold")) {
                            batchCountLabel.setFont(batchCountLabel.getFont().deriveFont(batchCountLabel.getFont().getStyle() | Font.BOLD));
                        } else {
                            batchCountLabel.setFont(batchCountLabel.getFont().deriveFont(batchCountLabel.getFont().getStyle() & ~Font.BOLD));
                        }
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_LABEL_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && handler != null && handler.getConfig() != null) {
                    batchCountLabel.setBackground(CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.COUNT == model.getSpeciesProtocolFrequencyMode() ? handler.getConfig().getColorHighlightInfoBackground() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_LABEL_FOREGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && handler != null && handler.getConfig() != null) {
                    batchCountLabel.setForeground(CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.COUNT == model.getSpeciesProtocolFrequencyMode() ? handler.getConfig().getColorHighlightInfoForeground() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountField.setNumberValue(model.getBatchCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("categorizationEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryPanel.setVisible(model.isCategorizationEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("categorizationEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("category", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setData(model.getCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("category", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setEnabled(model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_FREQUENCIES_BUTTON_FONT_WEIGHT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    if (saveAndFrequenciesButton.getFont() != null) {
                        if (( CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.MEASURE == model.getSpeciesProtocolFrequencyMode() ? "bold" : "normal" ).equals("bold")) {
                            saveAndFrequenciesButton.setFont(saveAndFrequenciesButton.getFont().deriveFont(saveAndFrequenciesButton.getFont().getStyle() | Font.BOLD));
                        } else {
                            saveAndFrequenciesButton.setFont(saveAndFrequenciesButton.getFont().deriveFont(saveAndFrequenciesButton.getFont().getStyle() & ~Font.BOLD));
                        }
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_FREQUENCIES_BUTTON_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && handler != null && handler.getConfig() != null) {
                    saveAndFrequenciesButton.setBackground(CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.MEASURE == model.getSpeciesProtocolFrequencyMode() ? handler.getConfig().getColorHighlightInfoBackground() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_FREQUENCIES_BUTTON_FOREGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && handler != null && handler.getConfig() != null) {
                    saveAndFrequenciesButton.setForeground(CreateSpeciesBatchUIModel.SpeciesProtocolFrequencyMode.MEASURE == model.getSpeciesProtocolFrequencyMode() && model.isValid() ? handler.getConfig().getColorHighlightInfoForeground() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesProtocolFrequencyMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_FREQUENCIES_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndFrequenciesButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}