package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MultiPostImportLogDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Vz28bRRR+NrETJ00LRC1FBGRMBamE1ikICSkImqZEJHKgIqla4QOMd8f2VLM705m3zUYWiD+BPwHuXJC4cUIcOHPggvgXEOLAFfFm1lnbZE2qWvLamvne93597+23f0DNGnj5AcuywKQJipgH+9v373/Ue8BDvM1taIRGZSD/VKpQ7cJKVJxbhFe6HWfeHpu3d1SsVcKTKeutDixbPJHcDjlHhBdnLUJr24fF9VamU3PKWgRVxvr1X39Wv4q+/KYKkGmKzqXSPM9qkslCB6oiQniWPD1ibcmSAYVhRDKgeFfd2Y5k1n7IYv4QvoDFDtQ1M0SG0Hr8lD2Ht880wlVBSIMHqURxR1nsqMFtwaQaIHT6JhB9w2NuAkwRRZCKwB5TOEGoEiT2QGluGAqVBCHDcMhtUBDted6CTmvvs46wGHNr2YAjXHYpZWPK/SOe4bbhzMEaBXr12v5haJSUd1jCNxGem7GZXM1aNXounI6w6A4uusel4nIllMryW5QRZQFrM4T56ZjMwAszzSNZBBNZTPpW6ULNpHRM5eyeVdLHdJVr6Op/NOQI/e0/V9Z+/eH373dPhVMn35dLoVO6p4Zq4zqAwrm+lKsmRSHbB0xvdaFhuaSh8UOxXhLY4fiagiN/zzjzwJkHHzA7JIra4m8//nTls1+eguouLEvFol3m8HvQwKGhKigZZfq9mz6iC8dL9HzaxYZQH3IxGJIuq29tZpT4eknihfde4+e/1w6/u3mafIWCeX4ufFKA2idQF4kUCfdzMx6J0jlZ0ZankZpIv2wYQGsaiJWel4DTlPQ36/7ZPJNmFaGGAiUp4aV8POIz2g/GgFqsIiYRFtCkPEsd4TWfqfv3KvzPGOrx4MyLokHF7ikTkQrgzVHzlv+bt+kkCGmckL8fazzJLzZubL7efIO++e/15udkHqbGkm9YGjWTVEp/pjR7mLrA+0xa+l1yZb5nmB7nQCc8Esh6cgq0ekwAPyD3yFuBbPRVmNpZ6ALStCO8NsKN1tzijRdF6zpFtNBXbs+1R83peb27d8ASgpiA9skuITZaHdbjMnDoFqVXVuvTBXReaSslSZbxTZbNeYw1hAvixtvJQcJjlYiQCjA3eb+kgrhALlNPadHuudULS4+YFBH1tqjkfAl6ItI1KiWPhD7y8PlFz/0ivTNg9VNLspR823tGUKMneSNYzUNaUEEef9kbYse5zOWeu6IgaCxLmze9vB+jgXXJThSB4eI7VC7W7IkkonDfPUNdcc9lYvwXrO7IM4IIAAA=";
    private static final Log log = LogFactory.getLog(MultiPostImportLogDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea batchList;
    protected JButton closeButton;
    protected final MultiPostImportLogDialogHandler handler = createHandler();
    protected MultiPostImportLogDialog importMultiPostLogDialog = this;
    protected JTextArea message;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultiPostImportLogDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog() {
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getBatchList() {
        return batchList;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public MultiPostImportLogDialogHandler getHandler() {
        return handler;
    }

    public JTextArea getMessage() {
        return message;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportMultiPostLogDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(message, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add(closeButton, BorderLayout.SOUTH);
    }

    protected void createBatchList() {
        $objectMap.put("batchList", batchList = new JTextArea());
        
        batchList.setName("batchList");
        batchList.setColumns(15);
        batchList.setLineWrap(true);
        batchList.setWrapStyleWord(true);
        batchList.setEditable(false);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.multiPostImportLog.close"));
        closeButton.setToolTipText(t("tutti.multiPostImportLog.close.tip"));
        closeButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.MultiPostImportLogCloseDialogAction.class);
    }

    protected MultiPostImportLogDialogHandler createHandler() {
        return new MultiPostImportLogDialogHandler();
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JTextArea());
        
        message.setName("message");
        message.setColumns(15);
        message.setLineWrap(true);
        message.setWrapStyleWord(true);
        message.setOpaque(false);
        message.setLineWrap(true);
        message.setEditable(false);
        message.setWrapStyleWord(true);
        message.setFocusable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportMultiPostLogDialog();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(batchList);
        
        // apply 7 property setters
        message.setBorder( BorderFactory.createEmptyBorder(10, 20, 10, 20) );
        message.setCursor( null );
        SwingUtil.setText(message, t("tutti.multiPostImportLog.message"));
        
        message.setFont( javax.swing.UIManager.getFont("Label.font") );
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.multiPostImportLog.close.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("validate"));
        // late initializer
        importMultiPostLogDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("importMultiPostLogDialog", importMultiPostLogDialog);
        createMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createBatchList();
        createCloseButton();
        // inline creation of importMultiPostLogDialog
        setName("importMultiPostLogDialog");
        importMultiPostLogDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.multiPostImportLog.title"));
        setModal(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}