/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.version.Version;

public abstract class UpdateSchemaContextSupport {
    private static final Log log = LogFactory.getLog(UpdateSchemaContextSupport.class);
    private Version schemaVersion;
    private Version schemaVersionIfUpdate;
    private boolean willUpdate;

    public Version getSchemaVersion() {
        return this.schemaVersion;
    }

    public Version getSchemaVersionIfUpdate() {
        return this.schemaVersionIfUpdate;
    }

    public boolean isNeedUpdate() {
        return this.schemaVersion.compareTo(this.schemaVersionIfUpdate) < 0;
    }

    public boolean isSchemaVersionTooHigh() {
        return this.schemaVersion.compareTo(this.schemaVersionIfUpdate) > 0;
    }

    public boolean isWillUpdate() {
        return this.willUpdate;
    }

    protected abstract boolean askUserToMigrate(Version var1, Version var2);

    public void init(Version schemaVersion, Version schemaVersionIfUpdate) {
        this.schemaVersion = schemaVersion;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Detected schema version: %s", schemaVersion));
        }
        this.schemaVersionIfUpdate = schemaVersionIfUpdate;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Detected schema version if update: %s", schemaVersionIfUpdate));
        }
        if (this.isSchemaVersionTooHigh()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Schema version %s is higher than incoming schema version %s, can't update!", schemaVersion, schemaVersionIfUpdate));
            }
        } else if (this.isNeedUpdate()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Schema version %s is smaller than incoming schema version %s, ask to update", schemaVersion, schemaVersionIfUpdate));
            }
            this.willUpdate = this.askUserToMigrate(schemaVersion, schemaVersionIfUpdate);
            if (log.isInfoEnabled()) {
                log.info((Object)("Should we update? " + this.willUpdate));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)String.format("Schema version %s is up-to-date, no need to update.", schemaVersion));
        }
    }
}

