/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.replace.AbstractReplaceTemporaryUI;
import fr.ifremer.tutti.ui.swing.content.referential.replace.AbstractReplaceTemporaryUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.awt.Dialog;
import java.util.List;
import javax.swing.JButton;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public abstract class AbstractOpenReplaceTemporaryUIAction<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>, UI extends AbstractReplaceTemporaryUI<E, M>>
extends LongActionSupport<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(AbstractOpenReplaceTemporaryUIAction.class);
    protected E source;
    protected E target;
    protected List<E> targetList;
    protected List<E> sourceList;

    protected abstract String getEntityLabel();

    protected abstract M createNewModel();

    protected abstract UI createUI(JAXXInitialContext var1);

    protected abstract List<E> getTargetList(PersistenceService var1);

    protected abstract List<E> retainTemporaryList(PersistenceService var1, List<E> var2);

    protected AbstractOpenReplaceTemporaryUIAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    protected abstract JButton getButton();

    public boolean prepareAction() throws Exception {
        boolean doAction;
        boolean bl = doAction = super.prepareAction() && this.getButton().isEnabled();
        if (doAction) {
            this.setProgressionModel(new ProgressionModel());
            this.getProgressionModel().setTotal(3);
        }
        return doAction;
    }

    public void releaseAction() {
        this.target = null;
        this.source = null;
        this.sourceList = null;
        this.targetList = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        String entityLabel = this.getEntityLabel();
        this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.loading.target", (Object[])new Object[]{entityLabel}));
        this.targetList = this.getTargetList(persistenceService);
        log.info((Object)("Loaded official referentials: " + this.targetList.size()));
        this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.loading.source", (Object[])new Object[]{entityLabel}));
        this.sourceList = this.retainTemporaryList(persistenceService, this.targetList);
        log.info((Object)("Loaded temporary referentials: " + this.sourceList.size()));
    }

    public void postSuccessAction() {
        boolean showDialog = true;
        String entityLabel = this.getEntityLabel();
        M model = this.createNewModel();
        if (this.targetList.isEmpty()) {
            showDialog = false;
            this.displayWarningMessage(I18n.t((String)"tutti.title.openReplaceTemporaryUI.noTarget", (Object[])new Object[]{entityLabel}), I18n.t((String)"tutti.message.openReplaceTemporaryUI.noTarget", (Object[])new Object[]{entityLabel}));
        } else {
            ((AbstractReplaceTemporaryUIModel)model).setTargetList(this.targetList);
        }
        if (this.sourceList.isEmpty()) {
            showDialog = false;
            this.displayWarningMessage(I18n.t((String)"tutti.title.openReplaceTemporaryUI.noSource", (Object[])new Object[]{entityLabel}), I18n.t((String)"tutti.message.openReplaceTemporaryUI.noSource", (Object[])new Object[]{entityLabel}));
        } else {
            ((AbstractReplaceTemporaryUIModel)model).setSourceList(this.sourceList);
        }
        if (showDialog) {
            this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.open.dialog", (Object[])new Object[0]));
            JAXXInitialContext ctx = new JAXXInitialContext();
            ctx.add((Object)this.getUI());
            ctx.add(model);
            UI dialog = this.createUI(ctx);
            MainUI mainUI = TuttiUIUtil.getApplicationContext(dialog).getMainUI();
            SwingUtil.setComponentHeight(dialog, (int)400);
            SwingUtil.setComponentWidth(dialog, (int)(mainUI.getWidth() - 100));
            SwingUtil.center((Component)mainUI, dialog);
            ((AbstractReplaceTemporaryUI)dialog).setContextValue((ApplicationUI)this.getUI(), "owner");
            ((Dialog)dialog).setVisible(true);
            ((TuttiUI)dialog).getHandler().onCloseUI();
        }
    }
}

