/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.parser.CompatibleOdaDataSourcePropertyState;
import org.eclipse.birt.report.model.parser.DataSourceState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParseStateFactory;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;

public class OdaDataSourceState
extends DataSourceState {
    private static final String OBSOLETE_FLAT_FILE_ID = "org.eclipse.birt.report.data.oda.flatfile";
    private static final String NEW_FLAT_FILE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";
    private boolean isValidExtensionId = true;
    private ODAProvider provider = null;

    public OdaDataSourceState(ModuleParserHandler handler, int slot) {
        super(handler, slot);
        this.element = new OdaDataSource();
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.parseODADataSourceExtensionID(attrs, false);
        this.initElement(attrs, true);
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue && (this.handler.isVersion(0) || this.handler.isVersion(1000000))) {
            return new CompatibleOdaDataSourcePropertyState(this.handler, this.getElement());
        }
        if (this.isValidExtensionId) {
            return super.startElement(tagName);
        }
        return ParseStateFactory.getInstance().createParseState(tagName, this.handler, (DesignElement)this.element, ((OdaDummyProvider)this.provider).getContentTree());
    }

    private void parseODADataSourceExtensionID(Attributes attrs, boolean extensionNameRequired) {
        String extensionID = this.getAttrib(attrs, "extensionID");
        if (StringUtil.isBlank(extensionID)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(this.element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            return;
        }
        if (this.handler.versionNumber < 3000000 && OBSOLETE_FLAT_FILE_ID.equalsIgnoreCase(extensionID)) {
            extensionID = NEW_FLAT_FILE_ID;
        }
        this.setProperty("extensionID", extensionID);
        this.provider = ((OdaDataSource)this.element).getProvider();
        if (this.provider == null) {
            return;
        }
        if (this.provider instanceof OdaDummyProvider) {
            SemanticError e = new SemanticError((DesignElement)this.element, new String[]{extensionID}, "Error.SemanticError.EXTENSION_NOT_FOUND");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            this.isValidExtensionId = false;
        } else {
            String newExtensionID = this.provider.convertExtensionID();
            if (!extensionID.equals(newExtensionID)) {
                this.setProperty("extensionID", newExtensionID);
            }
        }
    }
}

