/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesAbleBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecoratorComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortableRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataTableCell;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JTables;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.validator.NuitonValidatorResult;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel, SpeciesBatchTableModel, SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    private EnumMap<TableViewMode, RowFilter<SpeciesBatchTableModel, Integer>> tableFilters;
    protected SampleCategoryModel sampleCategoryModel;
    protected WeightUnit weightUnit;
    protected Integer qualitative_unsorted_id;

    public SpeciesBatchUIHandler() {
        super("speciesToConfirm", "species", "weight", "number", "comment", "attachment", "sampleCategoryWeight", "frequency");
    }

    @Override
    protected ColumnIdentifier<SpeciesBatchRowModel> getCommentIdentifier() {
        return SpeciesBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<SpeciesBatchRowModel> getAttachementIdentifier() {
        return SpeciesBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((TuttiEntity)bean)) {
                BatchContainer rootSpeciesBatch = this.getPersistenceService().getRootSpeciesBatch(bean.getId(), true);
                List catches = rootSpeciesBatch.getChildren();
                Integer firstCategoryId = this.sampleCategoryModel.getFirstCategoryId();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((boolean)firstCategoryId.equals(aBatch.getSampleCategoryId()), (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryId()));
                    SpeciesBatchRowModel speciesBatchRowModel = this.loadBatch(aBatch, null, rows);
                }
            }
            SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = this.getSpeciesColumnDecorator();
            SpeciesSortMode speciesSortMode = model.getSpeciesSortMode();
            SpeciesBatchDecoratorComparator<SpeciesBatchRowModel> comparator = this.getSpeciesRowComparator();
            SpeciesAbleBatchRowHelper.sortSpeciesRows(comparator, decorator, rows, speciesSortMode);
        }
        model.setRows(rows);
    }

    public SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        boolean result;
        SpeciesBatch batch = this.convertRowToEntity(row, true);
        NuitonValidatorResult validator = this.getValidationService().validateEditSpeciesBatch(batch);
        boolean bl = result = !validator.hasErrorMessagess();
        if (result && "validate".equals(this.getContext().getValidationContext()) && row.isBatchLeaf()) {
            List<SpeciesBatchFrequency> frequencies = SpeciesFrequencyRowModel.toEntity(row.getFrequency(), batch);
            result = this.getValidateCruiseOperationsService().isSpeciesBatchValid(batch, frequencies);
        }
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        SpeciesBatchTableModel tableModel = this.getTableModel();
        if ("sampleCategoryWeight".equals(propertyName)) {
            SampleCategory sampleCategory = (SampleCategory)newValue;
            Integer sampleCategoryId = sampleCategory.getCategoryId();
            SampleCategoryAble firstAncestorRow = row.getFirstAncestor(sampleCategory);
            int firstAncestorIndex = tableModel.getRowIndex((Serializable)((Object)firstAncestorRow));
            if (rowIndex != firstAncestorIndex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sample category " + sampleCategoryId + " weight was modified, First ancestor row: " + firstAncestorIndex + " will save it"));
                }
                this.saveRow((SpeciesBatchRowModel)firstAncestorRow);
                this.cleanrRowMonitor();
                return;
            }
        } else if ("speciesToConfirm".equals(propertyName)) {
            HashSet shell = Sets.newHashSet();
            row.collectShell(shell);
            boolean newVal = newValue == null ? false : (Boolean)newValue;
            for (SpeciesBatchRowModel rowToupdate : shell) {
                rowToupdate.setSpeciesToConfirm(newVal);
            }
            tableModel.fireTableRowUpdatedShell(shell);
        }
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(row.getSpecies(), row, "Sauvegarde des modifications du lot Capture - Esp\u00e8ces : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setRootNumber(0);
        model.setSpeciesDistinctSortedSpeciesCount(0);
        for (SpeciesBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
        this.getTable().clearSelection();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EVEN, HighlightPredicate.EDITABLE}), (Color)Color.WHITE);
        table.addHighlighter(evenHighlighter);
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.EDITABLE, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
                return row.isSpeciesToConfirm();
            }
        }}), (Color)toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.READ_ONLY, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
                return row.isSpeciesToConfirm() && !adapter.isEditable();
            }
        }}), (Color)toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableChangeSampleCategory = false;
        boolean enableAddSampleCategory = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        boolean enableEditFrequencies = false;
        if (rowIndex != -1) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            enableSplit = true;
            enableRemove = selectedRowCount == 1;
            enableRemoveSub = selectedRowCount == 1;
            enableRename = selectedRowCount == 1;
            enableEditFrequencies = selectedRowCount == 1;
            enableChangeSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            enableAddSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            boolean bl = enableCreateMelag = selectedRowCount > 1;
            if (enableSplit) {
                Integer lastSamplingId = this.sampleCategoryModel.getLastCategoryId();
                enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && ObjectUtils.notEqual((Object)lastSamplingId, (Object)row.getFinestCategory().getCategoryId()) && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            boolean firstCategory = false;
            Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
            SampleCategoryModelEntry category = null;
            ArrayList available = null;
            if (sampleCategoryId != null) {
                firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
                category = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
                if (category.getCaracteristic().isNumericType()) {
                    available = Collections.emptyList();
                } else {
                    SpeciesBatchRowModel firstAncestorRow = row.getFirstAncestor(sampleCategoryId);
                    Set<Serializable> used = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
                    available = Lists.newArrayList((Iterable)category.getCaracteristic().getQualitativeValue());
                    available.removeAll(used);
                    if (firstCategory) {
                        CaracteristicQualitativeValues.removeQualitativeValue((Collection)available, (int)this.qualitative_unsorted_id);
                    }
                }
            }
            if (enableChangeSampleCategory) {
                enableChangeSampleCategory = sampleCategoryId == null ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableAddSampleCategory) {
                enableAddSampleCategory = sampleCategoryId == null || firstCategory ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableEditFrequencies) {
                enableEditFrequencies = row.isBatchLeaf();
            }
            if (enableRename) {
                enableRename = row.isBatchRoot();
            }
            if (enableRemove) {
                // empty if block
            }
            if (enableRemoveSub) {
                enableRemoveSub = !row.isBatchLeaf();
            }
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setSplitBatchEnabled(enableSplit);
        model.setChangeSampleCategoryEnabled(enableChangeSampleCategory);
        model.setAddSampleCategoryEnabled(enableAddSampleCategory);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
        model.setEditFrequenciesEnabled(enableEditFrequencies);
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("actions for (" + rowIndex + "," + columnIndex + "):");
            builder.append("\nenableSplit:                ").append(enableSplit);
            builder.append("\nenableChangeSampleCategory: ").append(enableChangeSampleCategory);
            builder.append("\nenableAddSampleCategory:    ").append(enableAddSampleCategory);
            builder.append("\nenableRemove:               ").append(enableRemove);
            builder.append("\nenableRemoveSub:            ").append(enableRemoveSub);
            builder.append("\nenableRename:               ").append(enableRename);
            builder.append("\nenableCreateMelag:          ").append(enableCreateMelag);
            builder.append("\nenableEditFrequencies:      ").append(enableEditFrequencies);
            log.debug((Object)builder.toString());
        }
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return ((SpeciesBatchUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + ui));
        }
        this.qualitative_unsorted_id = QualitativeValueId.UNSORTED.getValue();
        this.weightUnit = this.getConfig().getSpeciesWeightUnit();
        this.sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        this.tableFilters = new EnumMap(TableViewMode.class);
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
        EditCatchesUIModel catchesUIModel = ui.getContextValue(EditCatchesUIModel.class);
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
        ui.setContextValue(model);
    }

    public void afterInit(SpeciesBatchUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + ui));
        }
        this.initUI(ui);
        List samplingOrder = this.sampleCategoryModel.getSamplingOrder();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Number> numberDecorator = this.getDecorator(Number.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.ID, "\\d{0,10}", (JTable)table);
        TableColumnExt speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, SpeciesBatchTableModel.SPECIES);
        speciesColumn.setSortable(true);
        SpeciesBatchDecorator speciesDecorator = SpeciesBatchDecorator.newDecorator();
        speciesColumn.putClientProperty((Object)"decorator", speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        for (SampleCategoryModelEntry sampleCategoryDef : this.sampleCategoryModel.getCategory()) {
            SampleCategoryColumnIdentifier<SpeciesBatchRowModel> columnIdentifier = SampleCategoryColumnIdentifier.newId(sampleCategoryDef.getLabel(), sampleCategoryDef.getCategoryId(), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]));
            Decorator<Number> decorator = sampleCategoryDef.getCaracteristic().isNumericType() ? numberDecorator : caracteristicDecorator;
            this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, columnIdentifier, decorator, defaultRenderer, this.weightUnit);
        }
        this.addColumnToModel((TableColumnModel)columnModel, ComputableDataTableCell.newEditor(Float.class, this.weightUnit, computedDataColor), ComputableDataTableCell.newRender(defaultRenderer, this.weightUnit, computedDataColor), SpeciesBatchTableModel.WEIGHT, this.weightUnit);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyCellComponent.newEditor(ui, computedDataColor), SpeciesFrequencyCellComponent.newRender(computedDataColor), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), SpeciesBatchTableModel.ATTACHMENT);
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel(this.weightUnit, this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)SpeciesBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                SpeciesBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("speciesSortMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesSortMode newValue = (SpeciesSortMode)((Object)evt.getNewValue());
                if (log.isInfoEnabled()) {
                    log.info((Object)("New species sort mode: " + (Object)((Object)newValue)));
                }
                SpeciesBatchUIHandler.this.selectFishingOperation(((SpeciesBatchUIModel)SpeciesBatchUIHandler.this.getModel()).getFishingOperation());
            }
        });
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("speciesDecoratorContextIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newValue = (Integer)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("New species decorator context index: " + newValue));
                }
                SpeciesBatchUIHandler.this.getSpeciesColumnDecorator().setContextIndex(newValue);
                SpeciesBatchUIHandler.this.selectFishingOperation(((SpeciesBatchUIModel)SpeciesBatchUIHandler.this.getModel()).getFishingOperation());
            }
        });
    }

    @Override
    protected void initBatchTable(JXTable table, TableColumnModelExt columnModel, SpeciesBatchTableModel tableModel) {
        super.initBatchTable(table, columnModel, tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(table);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SpeciesBatchTableModel tableModel = (SpeciesBatchTableModel)((Object)e.getSource());
                int type = e.getType();
                if (type == -1 || type == 1 || e.getLastRow() == Integer.MAX_VALUE) {
                    SpeciesBatchDecoratorComparator<SpeciesBatchRowModel> comparator = SpeciesBatchUIHandler.this.getSpeciesRowComparator();
                    SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = SpeciesBatchUIHandler.this.getSpeciesColumnDecorator();
                    comparator.init((JXPathDecorator<SpeciesBatchRowModel>)decorator, tableModel.getRows());
                }
            }
        });
        SpeciesAbleBatchRowHelper.installSpeciesColumnComparatorPopup(table, speciesColumn, (SpeciesSortableRowModel)this.getModel(), I18n.t((String)"tutti.species.surveyCode.tip", (Object[])new Object[0]), I18n.t((String)"tutti.species.name.tip", (Object[])new Object[0]));
    }

    protected JComponent getComponentToFocus() {
        return ((SpeciesBatchUI)this.getUI()).getTable();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((SpeciesBatchUI)this.ui).getSpeciesBatchAttachmentsButton().onCloseUI();
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public Integer getQualitative_unsorted_id() {
        return this.qualitative_unsorted_id;
    }

    public void addBatch(CreateSpeciesBatchUIModel batchRootRowModel) {
        if (batchRootRowModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            Species species = batchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            newRow.setNumber(batchRootRowModel.getBatchCount());
            CaracteristicQualitativeValue sampleCategory = batchRootRowModel.getSampleCategory();
            SampleCategory<?> category = newRow.getFirstSampleCategory();
            category.setCategoryValue((Serializable)sampleCategory);
            category.setCategoryWeight(batchRootRowModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            int insertIndex = SpeciesAbleBatchRowHelper.getIndexToInsert(tableModel.getRows(), newRow, ((SpeciesBatchUIModel)this.getModel()).getSpeciesSortMode(), this.getSpeciesColumnDecorator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will insert at index: " + insertIndex));
            }
            tableModel.addNewRow(insertIndex, newRow);
            JTables.doSelectCell((JTable)this.getTable(), (int)insertIndex, (int)0);
            this.addToSpeciesUsed(newRow);
            if (batchRootRowModel.getBatchCount() == null && batchRootRowModel.getSelectedCategory() != null) {
                this.splitBatch(batchRootRowModel.getSelectedCategory(), batchRootRowModel.getRows(), batchRootRowModel.getSampleWeight());
            }
        }
    }

    public void splitBatch(SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        JXTable table = this.getTable();
        int insertRow = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(insertRow);
        Float parentWeight = parentBatch.getFinestCategory().getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight((float)parentWeight.floatValue(), (float)totalRowWeight.floatValue());
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            newBatch.getFinestCategory().setSubSample(subSample);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(++insertRow, newBatch);
            JTables.selectFirstCellOnRow((JTable)this.getTable(), (int)insertRow, (boolean)false);
        }
        parentBatch.setChildBatch(newBatches);
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
    }

    public void addSampleCategoryBatch(SpeciesBatchRowModel parentBatch, SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        SpeciesBatchTableModel tableModel = this.getTableModel();
        int insertRow = tableModel.getNextChildRowIndex(parentBatch);
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isEditable() || !row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(insertRow++, newBatch);
        }
        List<SpeciesBatchRowModel> childBatch = parentBatch.getChildBatch();
        childBatch.addAll(newBatches);
        parentBatch.setChildBatch(childBatch);
        int categoryIndex = this.sampleCategoryModel.indexOf(sampleCategoryDef);
        Float parentWeight = parentBatch.getSampleCategoryByIndex(categoryIndex - 1).getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight((float)parentWeight.floatValue(), (float)totalRowWeight.floatValue());
        HashSet shell = Sets.newHashSet();
        parentBatch.collectShell(shell);
        for (SpeciesBatchRowModel rowModel : shell) {
            rowModel.getSampleCategoryByIndex(categoryIndex).setSubSample(subSample);
        }
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        tableModel.updateShell(shell, SwingUtil.getSelectedModelColumn((JTable)this.getTable()));
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.recomputeRowValidState(row);
            this.saveRow(row);
        }
    }

    public String getFilterSpeciesBatchRootButtonText(int rootNumber) {
        return I18n.t((String)"tutti.editSpeciesBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    public void collectChildren(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public SpeciesBatchRowModel loadBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        List speciesList;
        int i;
        String id = aBatch.getId();
        List frequencies = this.getPersistenceService().getAllSpeciesBatchFrequency(id);
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(this.weightUnit, this.sampleCategoryModel, aBatch, frequencies);
        List attachments = this.getPersistenceService().getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        if (parentRow == null && this.getContext().isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        Preconditions.checkNotNull((Object)sampleCategoryId, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryId, aBatch.getSampleCategoryValue(), this.weightUnit.fromEntity(aBatch.getSampleCategoryWeight()), this.weightUnit.fromEntity(aBatch.getSampleCategoryComputedWeight()));
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            Float childrenWeights = Float.valueOf(0.0f);
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                if (childrenWeights != null) {
                    Float weight = childRow.getFinestCategory().getNotNullWeight();
                    childrenWeights = weight == null ? null : Float.valueOf(childrenWeights.floatValue() + weight.floatValue());
                }
                batchChilds.add(childRow);
            }
            Float rowWeight = newRow.getFinestCategory().getNotNullWeight();
            boolean subSample = rowWeight != null && childrenWeights != null && Weights.isSmallerWeight((float)childrenWeights.floatValue(), (float)rowWeight.floatValue());
            for (SpeciesBatchRowModel childRow : batchChilds) {
                childRow.getFinestCategory().setSubSample(subSample);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    public void removeFromSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        Preconditions.checkNotNull(firstSampleCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove from speciesUsed: " + this.decorate((Serializable)categoryValue) + " - " + this.decorate((Serializable)row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)categoryValue, (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
            if (QualitativeValueId.SORTED_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
                model.decSpeciesDistinctSortedSpeciesCount();
            }
        }
    }

    public void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = ((SpeciesBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory sampleCategory = row.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        Float weight = catchBean.getWeight();
        catchBean.setWeight(this.weightUnit.toEntity(weight));
        catchBean.setFishingOperation(fishingOperation);
        SpeciesBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch((SpeciesBatch)parent.toBean());
        }
        catchBean.setSampleCategoryId(sampleCategory.getCategoryId());
        catchBean.setSampleCategoryValue(sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        catchBean.setSampleCategoryWeight(this.weightUnit.toEntity(categoryWeight));
        if (TuttiEntities.isNew((TuttiEntity)catchBean)) {
            String parentBatchId = null;
            if (parent != null) {
                parentBatchId = parent.getId();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.getPersistenceService().createSpeciesBatch(catchBean, parentBatchId, true);
            row.setId(catchBean.getId());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.getPersistenceService().saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toEntity(frequencyRows, catchBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.getPersistenceService().saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromEntity(this.weightUnit, frequency);
        row.setFrequency(frequencyRows);
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, Integer sampleCategoryId, Serializable categoryValue, Float categoryWeight, Float categoryComputedWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategoryById(sampleCategoryId);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        sampleCategory.setComputedWeight(categoryComputedWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            if (parentRow.isSpeciesToConfirm()) {
                newRow.setSpeciesToConfirm(true);
            }
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            for (Integer id : this.sampleCategoryModel.getSamplingOrder()) {
                if (id.equals(sampleCategoryId)) continue;
                newRow.setSampleCategory(parentRow.getSampleCategoryById(id));
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer, WeightUnit weightUnit) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator, weightUnit), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights(), weightUnit), columnIdentifier, weightUnit);
    }

    protected void addToSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Preconditions.checkNotNull(firstSampleCategory);
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate((Serializable)categoryValue) + " - " + this.decorate((Serializable)row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)categoryValue, (Object)row.getSpecies());
        if (QualitativeValueId.SORTED_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
            model.incSpeciesDistinctSortedSpeciesCount();
        }
        model.setRootNumber(model.getRootNumber() + 1);
    }

    protected SpeciesBatch convertRowToEntity(SpeciesBatchRowModel row, boolean convertParent) {
        Preconditions.checkNotNull((Object)row.getFinestCategory());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryId());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryValue());
        SpeciesBatch catchBean = row.toEntity();
        if (convertParent && row.getParentBatch() != null) {
            SpeciesBatch parent = this.convertRowToEntity(row.getParentBatch(), true);
            catchBean.setParentBatch(parent);
        }
        return catchBean;
    }

    public Set<Serializable> getSampleUsedValues(SpeciesBatchRowModel row, int sampleCategoryId) {
        List<Object> childs;
        HashSet usedValues = Sets.newHashSet();
        if (row.isBatchRoot()) {
            Species species = row.getSpecies();
            childs = Lists.newArrayList();
            for (SpeciesBatchRowModel rowToScan : ((SpeciesBatchUIModel)this.getModel()).getRows()) {
                if (!rowToScan.isBatchRoot() || !species.equals(rowToScan.getSpecies())) continue;
                childs.add(rowToScan);
            }
        } else {
            SpeciesBatchRowModel parentBatch = row.getParentBatch();
            childs = parentBatch.getChildBatch();
        }
        for (SpeciesBatchRowModel speciesBatchRowModel : childs) {
            SampleCategory<?> category = speciesBatchRowModel.getSampleCategoryById(sampleCategoryId);
            usedValues.add(category.getCategoryValue());
        }
        return usedValues;
    }

    protected SpeciesBatchDecoratorComparator<SpeciesBatchRowModel> getSpeciesRowComparator() {
        boolean comparatorNull;
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(this.getTable());
        SpeciesBatchDecoratorComparator comparator = (SpeciesBatchDecoratorComparator)((Object)speciesColumn.getComparator());
        SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = this.getSpeciesColumnDecorator();
        boolean bl = comparatorNull = comparator == null;
        if (comparatorNull) {
            comparator = (SpeciesBatchDecoratorComparator)decorator.getCurrentComparator();
        }
        if (comparatorNull) {
            speciesColumn.setComparator((Comparator)((Object)comparator));
        }
        return comparator;
    }

    protected SpeciesBatchDecorator<SpeciesBatchRowModel> getSpeciesColumnDecorator() {
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(this.getTable());
        SpeciesBatchDecorator decorator = (SpeciesBatchDecorator)SpeciesAbleBatchRowHelper.getSpeciesColumnDecorator(speciesColumn);
        return decorator;
    }
}

